/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2003 LUT. .
 *
 * @name WLANMonitor.cc
 * @memo WLAN implementation of the MAbstractMonitor interface.
 *
 * @version 0.1
 * date     31.07.2003
 * change   31.07.2003
 */
#include <iostream>
#include "WLANMonitor.h"
//temp
#include <syslog.h>

#define ERR(format, msg...) syslog(LOG_ERR, "ERROR: " format "\n" , ## msg)

#ifdef PH_DEBUG
#define DBG(format, msg...) syslog(LOG_DEBUG, format "\n" , ## msg)
#else
#define DBG( A... )
#endif
//temp

/**
 * @memo Constructor.
 * @doc Constructor, initializes the pinger object so that it can be used
 * immediately after the construction has finished.
 *
 * @param aAddress Remote device's address.
 *
 * @return none
 */
CWLANMonitor::CWLANMonitor(const std::string& aAddress) : MAbstractMonitor(aAddress)
{
  iAddress = std::string(aAddress);
  iInRange = true;
}

/**
 * @memo Default destructor.
 * @doc Default desttructor, deletes allocated variables
 *
 * @return none
 */
CWLANMonitor::~CWLANMonitor()
{
}

/**
 * @memo Monitores the signal level
 * @doc Monitores the signal level. Method uses Wireless extension
 * to obtain the signal value.
 *
 * @return signal level
 */
int CWLANMonitor::Monitor()
{
  char line[256], signalValue[64];
  int signalIntValue = 0;
  
  memset(line, 0, sizeof(line));
  memset(signalValue, 0, sizeof(signalValue));
  iWlanInfo=fopen("/proc/net/wireless","r");

  if(iWlanInfo) {
    
    fgets(line,sizeof(line), iWlanInfo);
    fgets(line,sizeof(line), iWlanInfo);
    fgets(line,sizeof(line), iWlanInfo);
    sscanf(line,"%*s %*s %s %*s %*s %*s %*s %*s",signalValue);
    signalIntValue = atoi(signalValue);
    fclose(iWlanInfo);
    return signalIntValue;
  }
  return -1;
};


/**
 * @memo Returns remote device's WLAN address.
 * @doc Return the WLAN address of the device under monitoring.
 *
 * @return remote device's address
 */
const std::string& CWLANMonitor::GetAddress()
{
  return iAddress;
}


/**
 * @memo Tells whether a device is in range or not.
 * @doc Tells whether a device is in range or not.
 *
 * @return true if the device is in range
 */
bool CWLANMonitor::InRange()
{
  return iInRange;
}

