/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008 LUT. .
 *
 * @name MaemoSystemListener.h
 * @memo DBUS listener class for Maemo environment. Class is used through
 * interface defined by MAbstractListener, belongs to PeerHood daemon only.
 * Class is created via ListenerFactory by using MaemoSystemCreator.
 * This class is used for state checking in Maemo environment.
 *
 * @version 0.14
 * date     25.08.2008
 * change   17.12.2008
 */

#ifndef __MAEMOSYSTEMLISTENER_H__
#define __MAEMOSYSTEMLISTENER_H__

#include <dbus/dbus.h>
#include <syslog.h>
#include <stdio.h>
#include "AbstractListener.h"
#include "AbstractStateConverter.h"

#define ERR(format, msg...) printf(format "\n",## msg)

#ifdef PH_DEBUG
#define DBG(format, msg...) syslog(LOG_DEBUG, format "\n" , ## msg)
#else
#define DBG( A... )
#endif

/**
 * @memo Maemo System listener class, checks for system state changes in Maemo
 * environment.
 * @doc The purpose of this class is to check and listen for system state changes in
 * Maemo via DBUS. Usage: periodically calls to CheckState()-function which every 
 * time checks the first message in the message queue, if the state can be read from
 * the message appropriate function of owner component is called. Uses a private 
 * connection to DBUS for listening messages, registers to com.nokia.mce.signal and 
 * com.nokia.bme.signal for listening. System state is requested from com.nokia.mce.request
 * interface at start. This is meant to be used by PeerHood daemon only.
 */
class CMaemoSystemListener : public MAbstractListener
{
public:
	CMaemoSystemListener(MAbstractStateConverter* aConverter);
	virtual ~CMaemoSystemListener();

	// Listener interface
	bool Connect();
	void Disconnect();
	void CheckInitialState();
	void CheckState();
	const std::string& GetName();

private:
	CMaemoSystemListener();
	bool SetupConnection();
	bool RegisterSignals();
	void HandleMessage(DBusMessage* message);

	// Connection object
	DBusConnection* iConnection;
	
	// Name of the listener
	std::string iName;
	
	//
	MAbstractStateConverter* iConverter;
	
	// Battery is on low charge, shutdown plugins, if device is set to charger
	// set back to false.
	bool iBatterylow;
};

#endif /*__MAEMOSystemLISTENER_H__*/
