/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name Logger.h
 * @memo PeerHood logger class.
 * interface.
 *
 * @version 0.1
 * date     17.04.2003
 * change   17.04.2003
 */

#ifndef __LOGGER_H__
#define __LOGGER_H__

#include <fstream>

enum LogType {
  DEBUG = 0x01,
  ERROR
};


/**
 * @memo PeerHood logger class.
 * @memo PeerHood logger class. This logging facility is used by the PeerHood
 * library and the related plugin libraries. Note that the daemon uses
 * different logging methods.
 */
class Logger
{
 public:
  static void SetTarget(const char* aTarget);
  static void Log(LogType aType, const char* aMessage);

 private:
  static Logger *iInstance;
  static std::ostream* iOut;
};

#define ERR(msg...) Logger::Log(ERROR, ## msg)

#ifdef PH_LIB_DEBUG
#define DBG(msg...) Logger::Log(DEBUG, ## msg)
#else
#define DBG(msg...)
#endif

#endif
