#include <iostream>
#include <unistd.h>
#include <cstdio>
#include <sstream>
#include <sys/types.h>
#include <PeerHood.h>
#include <netinet/in.h>
#include <time.h>
#include <fstream>
#include <list>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <string.h>
#include <stdlib.h>

#include "proto-REdecide.h"
#include "param.h"
#include "hot_cube.h"

#include <AbstractPlugin.h>

using namespace std;

#define DIR_CLIENT "/tmp/RE"


map<const char*, MAbstractPlugin*> pluginMap;
std::list<tdev_info> list_dev;

class ClientCallback : public CBasicCallback
{
 public:
  void Notify(TEventType aEvent, const string& aAddress);
  void NewConnection(const int aPort, MAbstractConnection* aConnection, int aConnectionId);  
};


void ClientCallback::Notify(TEventType aEvent, const string& aAddress)
{
  switch (aEvent) {
    case PH_DEVICE_LOST:
      cout << "The device " << aAddress << " is lost!" << endl;
      break;

    case PH_DEVICE_FOUND:
      cout << "The device " << aAddress << " is newly founded!" << endl;
      break;

  case PH_WEAK_LINK:
    cout << "Should change connection type from " << aAddress << endl;
    break;

    default:
      cerr << "Unknown event type!" << endl;
  }
}


void ClientCallback::NewConnection(const int aPort, MAbstractConnection* aConnection, int aConnectionId)
{
  cerr << "Someone tried to connect, target port is \"" << aPort << "\"" << endl;
  delete aConnection;
}

/***********************************************************
 * Print functions
 **********************************************************/


/*void print_dev(tdev_info b)
 * print the informations of the device b
 */
void print_dev(tdev_info b){
  cout << "Name : " << b.name << endl;
  cout << "Processor : " << b.processor << endl;
  cout << "Memory : " << b.memory << endl;
  cout << "Adresse : " << b.address << endl;
  cout << "Proto : " << b.proto << endl;
  //cout << "mobile : " << b.mobile << endl;
  //cout << "power connection : " << b.power_conection << endl;
}

/*void print_list_dev()
 * print the informations of all known devices
 */
void print_list_dev(){
  list<tdev_info>::iterator it;
  cout << "list of known devices : " << endl;
  for( it = list_dev.begin(); it != list_dev.end(); ++it ) {
    print_dev(*it);
    cout << endl;
  }
}

/*void print_task(ttask_info b)
 * print the informations of the task b
 */
void print_task(ttask_info b){
  cout << "memory needed : " << b.memory << endl;
  cout << "time on ref proc : "  << b.time_ref << endl;
  cout << "size to send : " << b.size_to_send << endl;
  cout << "size to recv : " << b.size_to_receive << endl;
}

/*void menu()
 * Print the menu
 */
void menu() {
  cout << endl << "Make your guess:" << endl;
  //cout << "  i - create rExe service" << endl;
  cout << "  t - hot cube" << endl;
  //cout << "  b - search server (better to use option c)" << endl;
  cout << "  c - actu server" << endl;

  cout << "  l - list known server" << endl;
  cout << "  p - print own dev" << endl;
  cout << "  g - define time and power coef" << endl;
  //cout << "  u - get graph" << endl;
  cout << "  h - test computing capacities (write a file with time)" << endl;
  cout << "  d - test data rate all dev" << endl;
  cout << "  e - test latency all dev" << endl; 

//cout << "  r - make calculation and decision" << endl;
  //cout << "  o - define dev manual" << endl;
  //cout << "  s - define dev with param" << endl;
  cout << "  q - quit" << endl;  
}

/*****************************************************************/


/*****************************************************************
 * Init functions
 * Thoses functions are not used
 *****************************************************************/
tdev_info init_dev(int memory, bool mobile, int power, int proc){
  tdev_info a;
  a.memory=memory;
  //a.mobile=mobile;
  //a.power_conection=power;
  a.processor=proc;
  return a;
}

ttask_info init_task(int memory,int time,int send,int recv){
  ttask_info a;
  a.memory=memory;
  a.time_ref=time;
  a.size_to_send=send;
  a.size_to_receive=recv;
  return a;  
}

/*****************************************************************/


/*Is_in_list(std::string address)
 * search if the device described by the address "address" is in the list of known devices
 */
tdev_info Is_in_list(std::string address){
  
  list<tdev_info>::iterator it;
  for( it = list_dev.begin(); it != list_dev.end(); ++it ) {
    if((*it).address==address) return *it;
  }
  tdev_info dev;
  dev.processor=0;
  return dev;
}

/*void  write_dev_in_file(tdev_info dev)
 * write the server information from "dev" in to a file
 */
void  write_dev_in_file(tdev_info dev){
  ofstream outFile;
  string tempstring;
  tempstring = DIR_CLIENT;
  tempstring += "/";
  tempstring += dev.address;
  outFile.open(tempstring.c_str());
  if(outFile){
    outFile << "Name:" << dev.name << endl;
    outFile << "Processor:" << dev.processor << endl;
    outFile << "Memory:" << dev.memory << endl;
    outFile << "Proto:" << dev.proto << endl;
    outFile.close();
  }else{
    cout << "Can not open file to write." << endl;  
  }
}

/* read a file a give back the server informations*/
tdev_info read_serv_file(string address){
  tdev_info dev;
  dev.processor = 0;
  ifstream inFile;
  string buffer;
  buffer = DIR_CLIENT;
  buffer += "/";
  buffer+= address;
  cout << "read file : " <<  buffer << endl;  
  inFile.open(buffer.c_str());             
  if (inFile){
    while (!inFile.eof()){     
      getline (inFile,buffer);
      if(buffer.length()!=0){
        if(buffer.compare(0,10,"Processor:")==0){
          std::istringstream ss( buffer.substr(10) );
          ss >> dev.processor;
        }
        if(buffer.compare(0,5,"Name:")==0){
          dev.name = buffer.substr(5);
        }
        if(buffer.compare(0,6,"Proto:")==0){
          dev.proto = buffer.substr(6);
        }
        if(buffer.compare(0,7,"Memory:")==0){
          std::istringstream ss( buffer.substr(7) );
          ss >> dev.memory;
        }     
      }
    }
    if((dev.memory !=0) && (dev.processor!=0)){
      dev.address=address;   
      inFile.close();
      return dev;         
    }else {
      dev.processor = 0;
    }               
  }else { 
    cout << "can not read file"<< endl;
    return dev;
  }
return dev;
}
float MakeDecide(ttask_info task, tdev_info own_dev,tdev_info remote_dev, int k_time, int k_power){
  //take a time reference on this computer
  int ref = 5000;
  float noise = 1.; // describe the quality of the link : number of time you have to send the same data
  int local_proc_burn = 8000;
  int local_proc_idle = 1000;
  int wireless_idle;
  int power_send;
  int power_recv;
  int lattency;
  
  float speed;
  
  //test memory
  if(own_dev.memory<task.memory){
    if(remote_dev.memory>task.memory){
      return true;
    }else{
      //il manque de la memoire sur les deux faire autre chose
    }
  }
  
  // execution time calculation
  float local_exe_time = (float)ref * task.time_ref/(float)own_dev.processor;
  float remote_exe_time = (float)ref * task.time_ref/(float)remote_dev.processor;
  
  // transfer time calculation
  if(remote_dev.proto == "bt-base"){
    speed = 9500.; 
    wireless_idle = 800;
    power_send = 1000;
    power_recv = 1100;
    lattency =880; 
  }
   
  if(remote_dev.proto == "wlan-base"){
    speed = 900000.;
    wireless_idle = 800;
    power_send = 1200;
    power_recv = 1000;
    lattency =585; 
  }
  
  float remote_send_time = task.size_to_send*noise/speed;
  float remote_recv_time = task.size_to_receive*noise/speed;
  
  // bilan
  float remote_total_time = remote_exe_time + remote_send_time + remote_recv_time + 2 ;
  float local_total_time = local_exe_time;
  float local_power = local_exe_time * (local_proc_burn +wireless_idle) ;
  float remote_power = remote_exe_time*(local_proc_idle+wireless_idle) + remote_send_time*power_send + remote_recv_time*power_recv;
  local_power/=10000;
  remote_power/=10000;
  // print stat
  cout << "local_exe_time : " << local_exe_time << endl;
  cout << "remote_exe_time : " << remote_exe_time << endl;
  cout << "remote_send_time : " << remote_send_time << endl;
  cout << "remote_recv_time : " << remote_recv_time << endl;
  cout << "local :" << endl << "Time : " <<  local_total_time << " Power : " << local_power<< endl;
  cout << "Remote :" << endl << "Time : " <<  remote_total_time << " Power : " << remote_power<< endl;
  float benef =(local_total_time -remote_total_time) * (float)k_time + (local_power-remote_power) * (float)k_power;
  cout << " we get a benef of : " << benef << endl;
  return benef;
  
}

/*void decide_all_dev()
 * print the informations of all known devices
 */
void decide_all_dev(ttask_info task,tdev_info own ,int k_time, int k_power){
  list<tdev_info>::iterator it;
  for( it = list_dev.begin(); it != list_dev.end(); ++it ) {
    print_dev(*it);
    MakeDecide(task,own,*it,k_time,k_power);
    cout << endl;
  }
}


std::string get_best_server(ttask_info task,tdev_info own, int k_time, int k_power ){
  list<tdev_info>::iterator it;
  float best = 0;
  tdev_info best_dev;
  float tmp = 0;
  for( it = list_dev.begin(); it != list_dev.end(); ++it ) {
    tmp=MakeDecide(task,own,*it,k_time,k_power);
    if(tmp > best){
      best = tmp;
      best_dev= *it;
    }
  }
  if(best > 0){ 
    return best_dev.address;
  }else{
    return "local";
  }
}


double ask_latency(tdev_info dev,MPeerHood* aPeerHood){
  stringstream strs;
  TDeviceList* list;
  int length;
  int actualRead = 0;
  int ilength;
  char* ibuffer;
  string buffer;
  clock_t Start;
  clock_t End;
  struct timeval start2,end2;
long mtime,seconds,useconds;
  MAbstractConnection* connection;
  std::string service(SERVICE_NAME);
  list = aPeerHood->GetDeviceListL(&service);
  for (TDeviceIterator i = list->Begin();i != list->End();++i){
    if((*i)->GetAddress()==dev.address){
      Start = clock();
      gettimeofday(&start2,NULL);
      connection = aPeerHood->Connect(i, SERVICE_NAME);
      if (!connection) {
        cout << "Failed to create a connection" << endl;
      }else{
        strs << MSG_ASK_LATENCY;
        buffer = strs.str();
        length = htonl(buffer.length());        
        connection->Write(&length, sizeof(length));
        connection->Write(buffer.c_str(), buffer.length());
        actualRead = connection->Read(&ilength, sizeof(ilength));
        if(actualRead != sizeof(ilength)){
          delete connection;
          connection = NULL;
        }else{
          ilength = ntohl(ilength);
          ibuffer = new char[ilength + 1];
          bzero(ibuffer, ilength + 1);
          if(connection->Read(ibuffer, ilength) != ilength){
            delete[] ibuffer;
            delete connection;
            connection = NULL;
            std::cout << "Receiving message failed" << std::endl;
          }else{
            cout << "[Received:] " << endl << ibuffer << endl;
            End = clock();
            gettimeofday(&end2,NULL);
            delete[] ibuffer;
            delete connection;
            connection =NULL;
            seconds = end2.tv_sec - start2.tv_sec;
            useconds = end2.tv_usec - start2.tv_usec;
            mtime = (long)(((seconds)*1000 + (double)useconds/1000.0)+0.5);

            cout << dev.address << " in " << mtime << " ms"<< endl;
            return clockdiffToSeconds(Start,End);
          }
        }
      }
    }
  }
  return 0;
}

void ask_latency_all(MPeerHood* aPeerHood){
  std::list<tdev_info>::iterator it; 
  for( it = list_dev.begin(); it != list_dev.end(); ++it ) {    
    cout << ask_latency(*it,aPeerHood) << endl;
  }
}

  
/* ListREdeviceCapable(MPeerHood* aPeerHood)
 * this function scan for all peerhood rExe service device capable
 * If the device is already known we do nothing.
 * if the device is not known we create the text file for the device 
 * and add it to the list of known devices
 */
void ListREdeviceCapable(MPeerHood* aPeerHood){
 
  TDeviceList* list;
  //TServiceList* services;
  tdev_info dev;
  stringstream strs;
  int length;
  int actualRead = 0;
  int ilength;
  char* ibuffer;
  string buffer;
  MAbstractConnection* connection;
  std::string service(SERVICE_NAME);
  list = aPeerHood->GetDeviceListL(&service);
  int id = 1; 
  if (list->Size() > 0){ 
    cout << "Following devices & services have been found:" << endl;   
    for (TDeviceIterator i = list->Begin();i != list->End();++i, ++id){
      cout << "  " << (*i)->GetAddress() << " proto: " << (*i)->GetPrototype();
      cout << " device name :" << (*i)->GetName() << endl;
      dev = Is_in_list((*i)->GetAddress());
      if(dev.processor!=0){
        cout << "dev already in list" << endl;
      }else{
        dev=read_serv_file((*i)->GetAddress());
        if(dev.processor!=0){
          list_dev.push_back(dev);
        }else{      
          connection = aPeerHood->Connect(i, SERVICE_NAME);
          if (!connection) {
            cout << "Failed to create a connection" << endl;
          }else{
            strs << MSG_ASK_POWER;
            buffer = strs.str();
            length = htonl(buffer.length());        
            connection->Write(&length, sizeof(length));
            connection->Write(buffer.c_str(), buffer.length());
            
            actualRead = connection->Read(&ilength, sizeof(ilength));
            if(actualRead != sizeof(ilength)){
              delete connection;
              connection = NULL;
              std::cout << "Size recv :" << actualRead  << std::endl;
            }else{
              ilength = ntohl(ilength);
              ibuffer = new char[ilength + 1];
              bzero(ibuffer, ilength + 1);
              if(connection->Read(ibuffer, ilength) != ilength){
                delete[] ibuffer;
                delete connection;
                connection = NULL;
                std::cout << "Receiving message failed" << std::endl;
              }else{
                cout << "[Received:] " << endl << ibuffer << endl;
                dev.address = (*i)->GetAddress();
                dev.proto = (*i)->GetPrototype();
                dev.name = (*i)->GetName();
                dev.memory=0;
                dev.processor=0;
                string tempstring;
                string tempstring2 = ibuffer+1;
                delete[] ibuffer;
                delete connection;
                connection =NULL;
                
                int loc=0;
                
                while(loc!=-1){
                  loc = tempstring2.rfind(',');
                  if (loc == -1){
                    tempstring = tempstring2;
                  }else{
                    tempstring = tempstring2.substr(loc+1);
                  }
    
                  if(tempstring.compare(0,10,"Processor:")==0){
                    std::istringstream ss( tempstring.substr(10) );               
                    ss >> dev.processor;
                  }
                  if(tempstring.compare(0,7,"Memory:")==0){
                    std::istringstream ss( tempstring.substr(7) );    
                    ss >> dev.memory;
                  }
                  tempstring2=tempstring2.substr(0,loc);
                }
                if(dev.memory==0 || dev.processor==0){
                  cout << "bad message recv" << endl;
                }else{
                  list_dev.push_back(dev);
                  write_dev_in_file(dev);              
                }
              }
            }
          }
        }    
      }     
    }   
  }else{
    cout << "No devices capable !" << endl;
  }
  delete list;
}



void remove_not_linkable_dev(MPeerHood* aPeerHood){
  TDeviceList* list;
  int s=0;
  std::string service(SERVICE_NAME);
  list = aPeerHood->GetDeviceListL(&service);
    for( std::list<tdev_info>::iterator it = list_dev.begin(); it != list_dev.end(); ++it ) {
      s=0;   
      for (TDeviceIterator i = list->Begin();i != list->End();++i){
        if((*it).address==(*i)->GetAddress()) s++;
      }
      if(s==0){
        list_dev.erase(it);
        it --;
      }
    }
    delete list;  
}


void ActuList(MPeerHood* aPeerHood){
 
  TDeviceList* list;
  tdev_info dev;
  stringstream strs;
  int length;
  int actualRead = 0;
  int ilength;
  char* ibuffer;
  string buffer;
  MAbstractConnection* connection;
  
  remove_not_linkable_dev(aPeerHood);
  std::string service(SERVICE_NAME);
  list = aPeerHood->GetDeviceListL(&service);
  int id = 1; 
  if (list->Size() > 0){ 
    for (TDeviceIterator i = list->Begin();i != list->End();++i, ++id){
      dev = Is_in_list((*i)->GetAddress());
      if(dev.processor!=0){       
        //cout << "dev already in list" << endl;
      }else{
        dev=read_serv_file((*i)->GetAddress());
        if(dev.processor!=0){
          list_dev.push_back(dev);
        }else{    
          connection = aPeerHood->Connect(i, SERVICE_NAME);
          if (!connection) {
             //return;
          }else{
            strs << MSG_ASK_POWER;
            buffer = strs.str();
            length = htonl(buffer.length());        
            connection->Write(&length, sizeof(length));
            connection->Write(buffer.c_str(), buffer.length());
            
            actualRead = connection->Read(&ilength, sizeof(ilength));
            if(actualRead != sizeof(ilength)){
              delete connection;
              connection = NULL;
  
            }else{
              ilength = ntohl(ilength);
              ibuffer = new char[ilength + 1];
              bzero(ibuffer, ilength + 1);
              if(connection->Read(ibuffer, ilength) != ilength){
                delete[] ibuffer;
                delete connection;
                connection = NULL;
              }else{
                dev.address = (*i)->GetAddress();
                dev.proto = (*i)->GetPrototype();
                dev.name = (*i)->GetName();
                dev.memory=0;
                dev.processor=0;
                string tempstring;
                string tempstring2 = ibuffer+1;
                delete[] ibuffer;
                delete connection;
                connection =NULL;             
                int loc=0;             
                while(loc!=-1){
                  loc = tempstring2.rfind(',');
                  if (loc == -1){
                    tempstring = tempstring2;
                  }else{
                    tempstring = tempstring2.substr(loc+1);
                  }
    
                  if(tempstring.compare(0,10,"Processor:")==0){
                    std::istringstream ss( tempstring.substr(10) );               
                    ss >> dev.processor;
                  }
                  if(tempstring.compare(0,7,"Memory:")==0){
                    std::istringstream ss( tempstring.substr(7) );    
                    ss >> dev.memory;
                  }
                  tempstring2=tempstring2.substr(0,loc);
                }
                if(dev.memory==0 || dev.processor==0){
                  cout << "bad message recv" << endl;
                }else{
                  list_dev.push_back(dev);
                  write_dev_in_file(dev);              
                }
              }
            }
          }
        }    
      }     
    }   
  }
  delete list;
}



/* void load_known_server()
 * Load the known server from the local files
 */
void load_known_server(){
  tdev_info dev;
  DIR *pdir=opendir(DIR_CLIENT);
  ifstream inFile;
  string buffer;
  struct dirent *dirp;
  if(pdir==NULL){
    mkdir(DIR_CLIENT,0777);
  }else{
    while ((dirp = readdir(pdir)) != NULL) {
      dev.memory=0;
      dev.processor=0;
      if(string(dirp->d_name)!="." && string(dirp->d_name)!=".."){
        dev =read_serv_file(string(dirp->d_name));
        if (dev.processor != 0){
          list_dev.push_back(dev);
        }else{
          cout << "error"<< endl;
        }
      }   
    }
    closedir(pdir);   
  }
}

int get_number_from_keyboard(string msg){
  int x=0;
  string badChars;
  cout << msg << endl;
  while(1){
    cout << "Enter a number > 0: ";
    if(!(cin >> x)) {
      cout << "The input stream broke!" << endl;
      cin.clear();
      cin >> badChars;
      cout << "You typed \"" << badChars << "\" instead of a number." << endl;
      cout << "Please try again." << endl;
    }
    else if(x < 1) {
      cout << "Your number is not big enough ! " << endl;
      cout << "Please try again." << endl;
      x=0;
    }else{
      return x;
    }
  }
return 1;
}


void test_data_rate(MPeerHood* aPeerHood){
  stringstream strs;
  TDeviceList* list;
  int length;
  int actualRead = 0;
  int ilength;
  char* ibuffer;
  string buffer;
struct timeval start2,end2;
long mtime,seconds,useconds;
  MAbstractConnection* connection;
  std::string service(SERVICE_NAME);
  list = aPeerHood->GetDeviceListL(&service);
  for (TDeviceIterator i = list->Begin();i != list->End();++i){
      connection = aPeerHood->Connect(i, SERVICE_NAME);
      if (!connection) {
        cout << "Failed to create a connection" << endl;
      }else{
        strs << MSG_SEND_DATA_RATE;
        buffer = strs.str();
        length = htonl(buffer.length());
	gettimeofday(&start2,NULL);        
        connection->Write(&length, sizeof(length));
        connection->Write(buffer.c_str(), buffer.length());
        cout << "Wait for connection" << std::endl;

        bool end_recv = true;
        ofstream fichier1("result.bin", ios::out | ios::trunc);  //déclaration du flux et ouverture du fichier 
        int nb_read =0;
        while(end_recv){
          nb_read++;
          actualRead = connection->Read(&ilength, sizeof(ilength));
          if(actualRead != sizeof(ilength)){
            cout << "Bad recv" << std::endl;
            delete connection;
            connection = NULL;
          }else{
            ilength = ntohl(ilength);
            if(ilength==0){
              cout << "Close connection" << endl;
              end_recv=false;
              fichier1.close();
              //delete[] ibuffer;
              delete connection;
              connection =NULL;
            }else{
              ibuffer = new char[ilength + 1];
              bzero(ibuffer, ilength + 1);
              if(connection->Read(ibuffer, ilength) != ilength){
                cout << "Bad Read message" << std::endl;
                delete[] ibuffer;
                delete connection;
                connection = NULL;
              }else{
                string tempstring2 = ibuffer;//+1
                fichier1 << tempstring2;           
              }
            }                                            
          }
        }
      }
    
gettimeofday(&end2,NULL);
            
            seconds = end2.tv_sec - start2.tv_sec;
            useconds = end2.tv_usec - start2.tv_usec;
            mtime = (long)(((seconds)*1000 + (double)useconds/1000.0)+0.5);

            cout << (*i)->GetAddress() << " in " << mtime << " ms"<< endl;
  }
}

void exec_remote(MPeerHood* aPeerHood,string server_addr, int nb_it, int w, int h, int out_tp, int in_tp, int s){
  stringstream strs;
  TDeviceList* list;
  int length;
  int actualRead = 0;
  int ilength;
  char* ibuffer;
  string buffer;
  MAbstractConnection* connection;
  std::string service(SERVICE_NAME);
  list = aPeerHood->GetDeviceListL(&service);
  for (TDeviceIterator i = list->Begin();i != list->End();++i){
    if((*i)->GetAddress()==server_addr){
      connection = aPeerHood->Connect(i, SERVICE_NAME);
      if (!connection) {
        cout << "Failed to create a connection" << endl;
      }else{
        strs << MSG_SEND_TASK<<nb_it<<";"<<w<<";"<<h<<";"<<out_tp<<";"<<in_tp<<";"<<s;
        buffer = strs.str();
        length = htonl(buffer.length());        
        connection->Write(&length, sizeof(length));
        connection->Write(buffer.c_str(), buffer.length());
        cout << "Wait for connection" << std::endl;

        bool end_recv = true;
        ofstream fichier1("result.bin", ios::out | ios::trunc);  //déclaration du flux et ouverture du fichier 
        ofstream fichier2("result.png", ios::out | ios::trunc);  //déclaration du flux et ouverture du fichier
        int file =1;
        int nb_read =0;
        while(end_recv){
          nb_read++;
          actualRead = connection->Read(&ilength, sizeof(ilength));
          if(actualRead != sizeof(ilength)){
            cout << "Bad recv" << std::endl;
            delete connection;
            connection = NULL;
          }else{
            ilength = ntohl(ilength);
            if(ilength==0){
              cout << "Close connection" << endl;
              end_recv=false;
              fichier1.close();
              fichier2.close();
              //delete[] ibuffer;
              delete connection;
              connection =NULL;
            }else{
              ibuffer = new char[ilength + 1];
              bzero(ibuffer, ilength + 1);
              if(connection->Read(ibuffer, ilength) != ilength){
                cout << "Bad Read message" << std::endl;
                delete[] ibuffer;
                delete connection;
                connection = NULL;
              }else{
                string tempstring2 = ibuffer;//+1
                string::size_type loc = tempstring2.find( ';');
                if( (loc != string::npos) && (file==1) ) {
                  fichier1 << tempstring2.substr(0,loc);
                  fichier2 << tempstring2.substr(loc+1) ;
                  file = 2;
                } else {
                  if(file==1){
                    fichier1 << tempstring2;
                  }else{
                    fichier2 << tempstring2;
                  }
                }             
              }
            }                                            
          }
        }
      }
    }
  }
}

void make_test(MPeerHood* aPeerHood,tdev_info own,int k_time,int k_power){
  struct timeval start2,end2;
long mtime,seconds,useconds;
  cout << "Values that can be executed on most computer : 1<x<10 1<y<10 50<s<200 100<it<10000" << endl;
  int w = 1; //get_number_from_keyboard("Enter the rectangle size x");
  int h = 1; //get_number_from_keyboard("Enter the rectangle size y");
  int s = get_number_from_keyboard("Enter the number of cube per unit s (transmission and execution time)");
  int nb_it = get_number_from_keyboard("Enter the number of iterations it (execution time)");
  int out_tp = 20;
  int in_tp = 100;
  //int start_temp= get_number_from_keyboard("Enter the start temperature value");
  std::string server_to_use;
  server_to_use= get_best_server(init_task(20,(int)((0.0039*s*s*h*w*nb_it)/1000.),30,(int)(7.9 *(double)(s*s*h*w)+ 18000) ),own,k_time,k_power);
  if(server_to_use=="local"){
    cout << "Local execution has been chosen" << endl;
gettimeofday(&start2,NULL);
    std::vector< std::vector< float > > tempe(w*s,std::vector<float>(h*s,in_tp));
    tempe = algo(nb_it,w, h,out_tp,tempe,s);
  }else{
    cout << "Remote execution has been chosen" << endl;
gettimeofday(&start2,NULL);
    exec_remote(aPeerHood,server_to_use,nb_it,w, h,out_tp,in_tp,s);
	std::stringstream cmd;
    cmd << "./script_plot.sh " << "result.bin "<< "image.png "<< w*s << " "<<  h*s << " " << "100" ;
	system(cmd.str().c_str());
  }
  gettimeofday(&end2,NULL);
            
  seconds = end2.tv_sec - start2.tv_sec;
  useconds = end2.tv_usec - start2.tv_usec;
  mtime = (long)(((seconds)*1000 + (double)useconds/1000.0)+0.5);

  cout << "the result can be found in your own folder" << endl;
  cout << "The execution has been done in " << mtime << " ms" << endl;
}

int local_test(){
  clock_t Start;
  clock_t End;
  ofstream fichier("test2.txt");
  int i=50;

  while(i<210){
    std::vector< std::vector< float > > tempe(i,std::vector<float>(i,100));
    Start = clock();
    tempe = algo(1000,1, 1,20,tempe,i);
    End=clock();
    fichier << i << " " << clockdiffToSeconds(Start, End)<< endl;
    i+=10;	
  }

  fichier.close();
  return 1;
}

int main(int argc, char** argv){
  MPeerHood* peerHood;
  ClientCallback* callback = new ClientCallback;
  bool end = false;
  fd_set selectSet;
  char cmd;
  int k_time = 50;
  int k_power = 50;
  
  peerHood = MPeerHood::GetInstance(callback);
  if (!peerHood->Init(argc, argv)) {
    cerr << "PeerHood initialization failed!" << endl;
    exit(EXIT_FAILURE);
  }
  
  load_known_server();
  //ActuList(peerHood);
  tdev_info dev_info;
  //ttask_info task_info;
  dev_info = define_param();
  
  while (!end) {
    menu();
    FD_ZERO(&selectSet);
    FD_SET(fileno(stdin), &selectSet);
    select(fileno(stdin) + 1, &selectSet, NULL, NULL, NULL);

    if (FD_ISSET(fileno(stdin), &selectSet)) {
      cin >> cmd;

      switch (cmd) {
        case 'q':
          end = true;
          break;
        case 't':
          make_test(peerHood,dev_info,k_time,k_power);
          break;
        
         case 'e':
          ask_latency_all(peerHood);
          break;
          
        case 'c':
          ActuList(peerHood);
          break;
        case 'g':
		k_time = get_number_from_keyboard("enter the k_time and k_power will be calculated");
		k_power = 100-k_time;
	  break;
 /*       case 'b':
          // look for rExe device capable
          ListREdeviceCapable(peerHood);
          //cout << "not yet ready !"  << endl;   
          break;
*/
 /*       case 'r':
          //execute makedecide function for all known devices
          decide_all_dev(task_info,dev_info,k_time,k_power);
          //cout << "not yet ready !"  << endl;   
          break;
*/
/*        case 's':
          //define dev with param
          dev_info = define_param();        
          break;
*/
	case 'h':
          local_test();        
          break;
          
        case 'l':
          //print list of rExe dev known
          print_list_dev();        
          break;
        
        case 'p':
          //print own dev
          print_dev(dev_info); 
          break;
          
        case 'd':          
          test_data_rate(peerHood);
          cout << "Done !" << endl; 
          break;
        
/*        case 'a':
          // print task
          print_task(task_info);
          //cout << "not yet ready !"  << endl; 
          break;
*/
 
      }
    }
    usleep(1);
  }

  delete peerHood;

  return EXIT_SUCCESS;
}
