#include <iostream>
#include <cstdio>
#include <sstream>
#include <time.h>
#include <fstream>
#include <sys/timeb.h> 
#include <limits>
#include "proto-REdecide.h"
#include "param.h"

using namespace std;

int toMips(int loops, double time) {
  int retVal;
  loops= loops/1000;
  return (retVal = (int)((double)loops/time));
}

double clockdiffToSeconds(clock_t start, clock_t end) {
  double retVal;  
  retVal = ((double)(end-start)/(double) CLOCKS_PER_SEC);
  return retVal;  
}

//work only on linux
unsigned long get_mem_total() {
    std::string token;
    std::ifstream file("/proc/meminfo");
    while(file >> token) {
        if(token == "MemTotal:") {
            unsigned long mem;
            if(file >> mem) {
                return mem;
            } else {
                return 0;       
            }
        }
        // ignore rest of the line
        file.ignore(std::numeric_limits<streamsize>::max(), '\n');
    }
    return 0; // nothing found
}


/* This function tries to approximate a fitting loopcount so that
** all devices would complete parametrization in 10-40 seconds
** seems to work as mobile devices and computers run in that time frame
** Reason for this is that too short run gives bad values, but
** we dont want to keep people waiting too long.
*/ 
int findLoopCount() {
  bool run = true;
  int i, loopCount= 1000;  // changed to 1k from 1M (still works atleast on fast computers quite good)
  int a, b;
  int tries=0;
  double testVal;
  clock_t Start;
  clock_t End;
  
  while(run==true) {
    testVal=0.0;    
    tries++; 
    a=0; b=1;
    Start = clock();
      
    for(i=0; i < loopCount ; i++) {a=a+b; b=a+b; b=b*a; a=a/b; }
    End = clock();
    
    
    testVal = clockdiffToSeconds(Start, End);
    if( testVal < 0.25 ) {
      if( testVal < 0.05 ) {      
        if( loopCount <  5000000 && loopCount != 50000000) loopCount = loopCount*2;
        else { loopCount = 100000000; run = false; }
      }
      else if( testVal > 0.05 && testVal < 0.25 ) {
        if( loopCount <  50000000) loopCount = loopCount*2;
        if( loopCount == 100000000) run = false;
      }
    }
    else run=false;   
  }
  return loopCount;
}

tdev_info param(){
  tdev_info device;
  volatile    int a=1234;
  volatile  int b=4321;
  volatile  float f1=0.00123;
  volatile  float f2=0.00456;
  volatile  double d1=0.0000123;
  volatile  double d2=0.0000456;
  double resultInt=0.0;
  double resultFloat=0.0;
  double resultDouble=0.0;
  int pr;

  clock_t Start;
  clock_t End;

  
  int iterationLimit = findLoopCount();
  int i;
  
  Start = clock();
  for(i=0; i < iterationLimit ; i++) {
    a=a+b;
    a=a*b;
    a=a-b;
    a=a/a;
  }
  End = clock();
  resultInt = clockdiffToSeconds(Start, End);
  resultInt = toMips(iterationLimit, resultInt);  
  
  Start = clock(); 
  for(i=0; i < iterationLimit ; i++) {
    f1=f1+f2;
    f1=f1*f2;
    f1=f1-f2;
    f1=f1/f1;
  }
  End = clock();
  resultFloat = clockdiffToSeconds(Start, End);
  resultFloat = toMips(iterationLimit, resultFloat);

  Start = clock();
  for(i=0; i < iterationLimit ; i++) {
    d1=d1+d2;
    d1=d1*d2;
    d1=d1-d2;   
    d1=d1/d1;
  }
  End = clock();
  resultDouble = clockdiffToSeconds(Start, End);
  resultDouble = toMips(iterationLimit, resultDouble);
  
  pr = (int)(resultInt + resultFloat + resultDouble)/3;
  device.processor= pr;
  device.memory = get_mem_total();
  return device;
}

tdev_info define_param(){
  tdev_info dev;
  string buffer,temp;
  ifstream inFile;
  dev.memory =0;
  dev.processor=0;
  inFile.open(FILE_OWN_PARAM);         
  if (inFile){
    while (!inFile.eof()){     
      getline (inFile,buffer);
      if(buffer.length()!=0){
        if(buffer.compare(0,10,"Processor:")==0){
          std::istringstream ss( buffer.substr(10) );
          ss >> dev.processor;
        }
        if(buffer.compare(0,7,"Memory:")==0){
          std::istringstream ss( buffer.substr(7) );
          ss >> dev.memory;
        }     
      }
    }
    if((dev.memory !=0) && (dev.processor!=0)){
      dev.name = "local";
      dev.address = "local";
      dev.proto = "local";
      inFile.close();
      return dev;
    }            
    inFile.close();
  }
  cout << "not able to open read file" << endl;
  cout << "takes time ! (~30s)" << endl;
  dev = param();
  ofstream outFile;
  outFile.open(FILE_OWN_PARAM);
  if(outFile){
    outFile << "Processor:" << dev.processor << endl;
    outFile << "Memory:" << dev.memory << endl;
    outFile.close();
  }else{
    cout << "Can not open file to write." << endl;
  }
  cout << "Done !" << endl;
  return dev;
}


/*int main(int argc, char** argv) 
{
tdev_info dev= param();
print_dev(dev);


return 0;
}*/
