/* $Id: libossomm.h,v 1.4 2005/08/23 15:43:32 murrayc Exp $ */
/* 
 *
 * Copyright 2007 The maemomm development team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LIBOSSOMM_INIT_H
#define LIBOSSOMM_INIT_H

#include <glibmm/ustring.h>
#include <glibmm/main.h>
#include <libosso.h> //TODO: Hide this?

namespace Osso
{

/**
 * This function initializes the library, connects to both the D-BUS session
 * and system busses, integrates with the GLib main loop, and
 * initializes the library for use. It should be called
 * only once by the application.
 * @param application The name of the application.
 * This name forms the last part of the default (D-BUS) service name of the
 * application. Note that the D-BUS service name will be
 * 'com.nokia.application', where 'application' is the value you gave as the
 * parameter. Note also that this argument must be identical to the
 * X-Osso-Service value in the desktop file, or the D-BUS daemon will kill
 * your application.
 * The only valid characters that the name may contain are letters a-z and
 * the underscore '_'.
 * @param version The version string of the application. It must be 
 * comparable with strcmp().
 * @return A context to use in later calls to this library. NULL is
 * returned if an error happened.
 */
osso_context_t* initialize(const Glib::ustring& application, const Glib::ustring& version);

/**
 * This function initializes the library, connects to both the D-BUS session
 * and system busses, integrates with the GLib main loop, and
 * initializes the library for use. It should be called
 * only once by the application.
 * @param application The name of the application.
 * This name forms the last part of the default (D-BUS) service name of the
 * application. Note that the D-BUS service name will be
 * 'com.nokia.application', where 'application' is the value you gave as the
 * parameter. Note also that this argument must be identical to the
 * X-Osso-Service value in the desktop file, or the D-BUS daemon will kill
 * your application.
 * The only valid characters that the name may contain are letters a-z and
 * the underscore '_'.
 * @param version The version string of the application. It must be 
 * comparable with strcmp().
 * @param context The GLib main loop context to connect to.
 * @return A context to use in later calls to this library. NULL is
 * returned if an error happened.
 */
osso_context_t* initialize(const Glib::ustring& application, const Glib::ustring& version, const Glib::RefPtr<Glib::MainContext>& context);


} //namespace Osso

#endif /* #ifndef LIBOSSOMM_INIT_H */
