/* $Id: rpc.cc,v 1.4 2005/08/23 15:43:32 murrayc Exp $ */
/* 
 *
 * Copyright 2007 The maemomm development team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libossomm/rpc.h>
#include <glibmm/utility.h>
#include <libosso.h>

namespace Osso
{

static gint
on_rpc(const gchar* interface, const gchar* method, GArray* arguments, gpointer data, osso_rpc_t* retval)
{
  int rc = 0;
  SlotRPC* slot = static_cast<SlotRPC*>(data);
  if(slot)
  {
    osso_rpc_t retval2;
    rc = (*slot)(
      Glib::convert_const_gchar_ptr_to_stdstring(interface), 
      Glib::convert_const_gchar_ptr_to_stdstring(method), 
      arguments,
      (retval ? *retval : retval2) );
  }
  return rc;
}

osso_return_t rpc_set_cb (osso_context_t* osso, const std::string& service,
				 const std::string& object_path,
				 const std::string& interface, const SlotRPC& slot)
{
  SlotRPC* slot_copy = new SlotRPC(slot);
  return osso_rpc_set_cb_f(osso, service.c_str(), object_path.c_str(), interface.c_str(), &on_rpc, slot_copy);
  //TODO: osso_rpc_set_cb_f() should take a destroy func.
}

} //namespace Osso
