/* $Id: autosave.h,v 1.4 2005/08/23 15:43:32 murrayc Exp $ */
/* 
 *
 * Copyright 2007 The maemomm development team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LIBOSSOMM_INIT_H
#define LIBOSSOMM_INIT_H

#include <sigc++/sigc++.h>
#include <libosso.h> //TODO: Hide this?

namespace Osso
{

/** For instance, 
 * @code
 * void on_autosave();
 * @endcode
 */
typedef sigc::slot<void> SlotAutoSave;

/**
 * This function registers an autosave callback function.
 *
 * @param osso The library context as returned by initialize().
 * @param slot The callback function.
 * @return #OSSO_OK if all goes well, #OSSO_ERROR if an error occurred, or
 * #OSSO_INVALID if some parameter is invalid.
 */
osso_return_t application_set_autosave_cb(osso_context_t* osso, const SlotAutoSave& slot);

} //namespace Osso

#endif /* #ifndef LIBOSSOMM_INIT_H */
