<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="UID"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="PRIVATE"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response_users_getInfo"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response_users_getInfo">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">profile</xsl:attribute>
        <xsl:attribute name="function">getBaseProfile</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>mm</xsl:text>
                <xsl:value-of select="user/uid"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">FirstName</xsl:attribute>
                <xsl:value-of select="user/first_name"/>
            </xsl:element> 

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">NickName</xsl:attribute>
                <xsl:value-of select="user/nick"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">LastName</xsl:attribute>
                <xsl:value-of select="user/last_name"/>
            </xsl:element>

        </xsl:element> 
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
