<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="UID"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="PRIVATE"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response_messages_getThreadsList"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response_messages_getThreadsList">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">messages</xsl:attribute>
        <xsl:attribute name="function">getListThreads</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">threadList</xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(thread/user/uid)"/>
                </xsl:attribute>                             
   
                <xsl:for-each select="thread">
                    <xsl:if test="user/uid">
                        <xsl:element name="{$STRUCT}">
                            <xsl:attribute name="name">thread</xsl:attribute>
                            <xsl:attribute name="id">
                                <xsl:text>mm</xsl:text>
                            <xsl:value-of select="user/uid"/>
                            </xsl:attribute>
                     
                            <xsl:element name="{$NUMBER}">
                                <xsl:attribute name="name">time</xsl:attribute>
                                <xsl:value-of select="time"/>
                            </xsl:element>

                            <xsl:element name="{$NUMBER}">
                                <xsl:attribute name="name">size</xsl:attribute>
                                <xsl:value-of select="number(incoming) + number(outgoing)"/>
                            </xsl:element>

                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
