#include <microfeed-common/microfeedmain.h>
#include <microfeed-provider/microfeedprovider.h>
#include <microfeed-provider/microfeedpublisher.h>
#include <microfeed-provider/microfeedfeed.h>

static MicrofeedPublisher* instantiate_publisher(MicrofeedProvider* provider, const char* publisher_identifier, const char* directory, void* user_data);
static MicrofeedFeed* instantiate_feed(MicrofeedPublisher* publisher, const char* uri, int create, void* user_data);
static void no_more_publishers(MicrofeedProvider* publisher, void* user_data);
static void initialize_settings(MicrofeedPublisher* publisher, void* user_data);
static int update_setting(MicrofeedPublisher* publisher, const char* key, const char* value, void* user_data);
static void* add_timeout(MicrofeedProvider* provider, unsigned long int interval, MicrofeedProviderTimeoutHandler handler, void* data, void* user_data);
static void remove_timeout(MicrofeedProvider* provider, void* timeout_implementation, void* user_data);
static MicrofeedError* download_image(MicrofeedPublisher* publisher, const char* url, void** data, size_t* length, void* user_data);
static MicrofeedError* update_comments_feed(MicrofeedFeed* feed, int user_initiated, void* user_data);

static MicrofeedProviderCallbacks provider_callbacks = {
	.instantiate_publisher = instantiate_publisher,
	.no_more_publishers = no_more_publishers,
	.add_timeout = add_timeout,
	.remove_timeout = remove_timeout
};

static MicrofeedPublisherCallbacks publisher_callbacks = {
	.instantiate_feed = instantiate_feed,
	.initialize_settings = initialize_settings,
	.update_setting = update_setting,
	.store_data = download_image
};

int main(void) {
	MicrofeedMain* main;
	MicrofeedProvider* provider;
	MicrofeedPublisher* publisher;
	MicrofeedFeed* feed;

	dbus_threads_init_default();
	microfeed_thread_init();
	microfeed_http_init(1);
	
	main = microfeed_main_new();
	provider = microfeed_provider_new("test.feed", microfeed_main_get_dbus_connection(main), &provider_callbacks, NULL);
	publisher = microfeed_publisher_new(
	
	feed = microfeed_feed_

	return 0;
}
