#include <microfeed-provider/microfeeddatabase.h>
#include <microfeed-common/microfeeditem.h>
#include <microfeed-common/microfeedobject.h>
#include <microfeed-common/microfeedmisc.h>
#include <stdio.h>

int main(void) {
	MicrofeedDatabase* database;
	MicrofeedDatabaseTable* table;
	MicrofeedDatabaseIndex* uid_index;
	MicrofeedDatabaseIndex* timestamp_uid_index;
	int i;
	char buffer[1024];
	MicrofeedItem* item;
	const void* const_data;
	size_t size;
	MicrofeedDatabaseIterator* iterator;
	void* data;
	
	unlink("/tmp/test-db");
	
	database = microfeed_database_new("test-db", "/tmp");
	table = microfeed_database_get_table(database, "table");
	uid_index = microfeed_database_table_get_index(table, "uid", 1, (MicrofeedDatabaseIndexFunction)microfeed_item_marshalled_get_uid, microfeed_database_compare_keys_direct);
	timestamp_uid_index = microfeed_database_table_get_index(table, "timestamp", 1, (MicrofeedDatabaseIndexFunction)microfeed_item_marshalled_get_timestamp_uid, (MicrofeedDatabaseCompareFunction)microfeed_database_compare_keys_direct);
	microfeed_assert(uid_index && timestamp_uid_index);

	for (i = 0; i < 100; i++) {
		snprintf(buffer, 1024, "uid-%d", i);
		item = microfeed_item_new(buffer, random());
		microfeed_item_set_property(item, "property", "value");
		microfeed_item_marshal(item, &const_data, &size);
		microfeed_database_index_replace_data(uid_index, const_data, size);
		microfeed_item_free(item);
	}

	item = microfeed_item_new("uid-20", 219761976);
	microfeed_item_set_property(item, "property2", "value2");
	microfeed_item_marshal(item, &const_data, &size);
	microfeed_database_index_replace_data(uid_index, const_data, size);
	microfeed_item_free(item);

	printf("uid:\n");
	for (iterator = microfeed_database_index_iterate(uid_index, NULL, 0, 0), i = 0;
	     microfeed_database_iterator_get(iterator, &data, &size);
	     microfeed_database_iterator_next(iterator), i++) {
	 	item = microfeed_item_new_from_marshalled(data, size);
		free(data);
		printf("item: %s %ld\n", microfeed_item_get_uid(item), microfeed_item_get_timestamp(item));
		microfeed_item_set_timestamp(item, random());
		microfeed_item_marshal(item, &const_data, &size);
		microfeed_database_index_replace_data(uid_index, const_data, size);
		microfeed_item_free(item);
		if (i == 10) {
			printf("REMOVED\n");
			microfeed_database_index_remove_data(uid_index, "uid-20", strlen("uid-20") + 1);
		}
	}
	microfeed_database_iterator_free(iterator);

	printf("timestamp_uid:\n");
	for (iterator = microfeed_database_index_iterate(timestamp_uid_index, NULL, 0, 0);
	     microfeed_database_iterator_get(iterator, &data, &size);
	     microfeed_database_iterator_next(iterator)) {
	 	item = microfeed_item_new_from_marshalled(data, size);
		printf("item: %s %ld\n", microfeed_item_get_uid(item), microfeed_item_get_timestamp(item));
		microfeed_item_free(item);
		free(data);
	}
	microfeed_database_iterator_free(iterator);
	
	microfeed_object_unref(uid_index, MicrofeedDatabaseIndex);
	microfeed_object_unref(timestamp_uid_index, MicrofeedDatabaseIndex);
	microfeed_object_unref(table, MicrofeedDatabaseTable);
	microfeed_object_unref(database, MicrofeedDatabase);

	return 0;
}

