/*
 *  Microfeed - Backend for accessing feed-based services
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation, or under the terms of the GNU Lesser General
 *  Public License version 2.1 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MICROFEEDMISC_H
#define MICROFEEDMISC_H

#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>

/**
 * @addtogroup common libmicrofeed-common - Common modules used both in the publisher and in the subscriber side
 * @{
 * @addtogroup MicrofeedMisc
 *
 * Miscellaneous utilities, suchs as support for weak references.
 *
 * @{
 */

#define microfeed_assert(x) if (!(x)) { microfeed_assert_failed(#x); }

#define microfeed_memory_allocate(t) ((t*)microfeed_memory_allocate_impl(sizeof(t), #t))
void* microfeed_memory_allocate_impl(size_t size, const char* name);
void* microfeed_memory_allocate_bytes(size_t size);
#define microfeed_memory_allocate_with_strings(t,...) ((t*)microfeed_memory_allocate_with_strings_impl(sizeof(t),__VA_ARGS__))
/* #define microfeed_memory_free(p) free(p) */
void microfeed_memory_free(void* p);

char* microfeed_util_string_concatenate(const char* s, ...);
char* microfeed_util_string_append(char* s, ...);
char* microfeed_util_string_percent_encoding_escape(const char* s);
char* microfeed_util_string_percent_encoding_unescape(const char* s);
char* microfeed_util_string_base64_encode(const char* s, size_t length);
size_t microfeed_util_string_starts_with(const char* s, const char* prefix);

int microfeed_util_create_directory_recursively(const char* directory);

int microfeed_util_file_copy(const char* source_path, const char* destination_path);

void microfeed_assert_failed(const char* text);

/**
 * @}
 * @}
 */

#endif
