<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
	 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="text"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/df:error_response"/>
 <xsl:apply-templates select="/data/info_response"/>
 <xsl:apply-templates select="/data/df:fql_query_response"/>
  <xsl:apply-templates select="/data/response"/>
</xsl:template>

<xsl:template match="response">
    <xsl:choose>
        <xsl:when test="contains(/data/Request/Params/string[@name='albumId'],'@')">
						<xsl:element name="{$REQUEST}">
								<xsl:attribute name="class">photos</xsl:attribute>
								<xsl:attribute name="function">sendPhotoCommentLast</xsl:attribute>
								<xsl:element name="{$PARAMS}">
								    <xsl:element name="{$STRING}">
								        <xsl:attribute name="name">text</xsl:attribute>
								        <xsl:value-of select="/data/Request/Params/string[@name='text']"/>
								    </xsl:element>
								    <xsl:element name="{$STRING}">
								        <xsl:attribute name="name">object_id</xsl:attribute>
								        <xsl:value-of select="substring-after(/data/Request/Params/string[@name='albumId'], '@')"/>
								    </xsl:element>
								</xsl:element>
						</xsl:element>
        </xsl:when>
        <xsl:otherwise>
						<xsl:element name="{$REQUEST}">
								<xsl:attribute name="class">photos</xsl:attribute>
								<xsl:attribute name="function">sendPhotoCommentMiddle</xsl:attribute>
								<xsl:element name="{$PARAMS}">
								    <xsl:element name="{$STRING}">
								        <xsl:attribute name="name">text</xsl:attribute>
								        <xsl:value-of select="/data/Request/Params/string[@name='text']"/>
								    </xsl:element>
								    <xsl:element name="{$STRING}">
								        <xsl:attribute name="name">albumId</xsl:attribute>
								        <xsl:value-of select="/data/Request/Params/string[@name='albumId']"/>
								    </xsl:element>
								    <xsl:element name="{$STRING}">
								        <xsl:attribute name="name">photoId</xsl:attribute>
								        <xsl:value-of select="/data/Request/Params/string[@name='photoId']"/>
								    </xsl:element>
								</xsl:element>
						</xsl:element>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="df:fql_query_response">

</xsl:template>

</xsl:stylesheet>
