/*
 * interface.h - interface functions for MySocials driver.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009, 2010 - MySocials team
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#ifndef _INTERFACE_H
#define _INTERFACE_H

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <glib/gprintf.h>

#include "mysocials_driver.h"
#include "driver_config.h"

#define G_LOG_LEVEL_ERROR

/**
 * Initialize driver
 */
extern error_type msa_module_init(struct msa_module *);

/**
 * Get info about driver
 */
extern void msa_module_get_info(struct msa_module *);

#endif
