<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="text"/>
    <xsl:param name="MID"/>  
    <xsl:param name="SID"/>  
    <xsl:param name="SECRET"/>

    <xsl:param name="LIMIT">100000</xsl:param>
    <xsl:variable name="URL" select="'url'"/>
    <xsl:variable name="SIG" select="'sig'"/>
    <xsl:variable name="STRING" select="'string'"/>
    <xsl:variable name="PARSER" select="'parser'"/>
    <xsl:variable name="POST_PARAM" select="'post_param'"/>
    <xsl:variable name="RESPONSE" select="'Response'"/>
    <xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
    <xsl:variable name="FUNCTION" select="/Request/@function"/>  
    <xsl:variable name="PARAMS" select="/Request/Params"/>  
    <xsl:variable name="PARAMS_ALL" select="document('requests.xml')//requests/request[@function=$FUNCTION]"/>  

<xsl:template match="//Request">
    <xsl:choose>
          <xsl:when test="$FUNCTION = document('requests.xml')//requests/request/@function">
                <xsl:element name="{$INNER_REQUEST}">
                    <xsl:attribute name="type">
                       <xsl:value-of select="$PARAMS_ALL/type"/>
                    </xsl:attribute>

                    <xsl:if test="($PARAMS_ALL/type = 'get') or ($PARAMS_ALL/type = 'webauth') or ($PARAMS_ALL/type = 'post')">
                        <xsl:element name="{$URL}">
                            <xsl:choose>
                                <xsl:when test="$PARAMS_ALL/type = 'post'">
                                    <xsl:call-template name="url-replace">
                                      <xsl:with-param name="text" select="$PARAMS_ALL/url" />
                                      <xsl:with-param name="replace" select="1" />
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of  select="$PARAMS_ALL/url" />
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:element>
                        <xsl:element name="{'params'}">
                           <xsl:for-each select="$PARAMS_ALL/param"> 
                               <xsl:if test="not(@id)">
                                  <xsl:value-of select="@name"/>
                                  <xsl:text>=</xsl:text>
                                  <xsl:choose>
                                  <xsl:when test="@multiple = 'true'">
                                      <xsl:call-template name="arg-replace">
                                        <xsl:with-param name="text" select="." />
                                        <xsl:with-param name="replace" select="1" />
                                        <!--xsl:with-param name="type" select="param" /-->
                                      </xsl:call-template>
                                  </xsl:when>
                                  <xsl:when test="@select != '.'">
                                      <xsl:apply-templates select="$PARAMS">
                                        <xsl:with-param name="node">
                                            <xsl:value-of select="@select"/>
                                        </xsl:with-param>
                                      </xsl:apply-templates>
                                  </xsl:when>
                                  <xsl:otherwise>
                                          <xsl:value-of select="."/>
                                  </xsl:otherwise>
                                  </xsl:choose>
                                  <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                               </xsl:if>
                           </xsl:for-each>
                           <xsl:if test = "$PARAMS_ALL/url/@sig != 'false'">
                               <xsl:text>access_token=</xsl:text>
                               <xsl:value-of select="$SID"/>
                           </xsl:if>  
                           <!--xsl:text disable-output-escaping="yes">&amp;</xsl:text-->
                        </xsl:element>
                    </xsl:if>                    




                    <xsl:if test="$PARAMS_ALL/type = 'upload'">
                        <xsl:copy select="$PARAMS_ALL/url" >
                           <xsl:attribute name="class">
                            <xsl:value-of select="$PARAMS_ALL/url/Request/@class"/>
                           </xsl:attribute>
                           <xsl:attribute name="function">
                            <xsl:value-of select="$PARAMS_ALL/url/Request/@function"/>
                           </xsl:attribute>
                           <xsl:copy-of select="$PARAMS"/>
                        </xsl:copy>
                       <xsl:for-each select="$PARAMS_NO_GENERAL/file_param"> 
                            <xsl:element name="{@name}">
                                <xsl:choose>
                                <xsl:when test="@select != '.'">
                                    <xsl:apply-templates select="$PARAMS">
                                      <xsl:with-param name="node">
                                        <xsl:value-of select="@select"/>
                                      </xsl:with-param>
                                    </xsl:apply-templates>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="."/>
                                </xsl:otherwise>
                                </xsl:choose>
                            </xsl:element>
                        </xsl:for-each>        
                    </xsl:if>

                    <xsl:if test="$PARAMS_ALL/type = 'download'">
                        <xsl:element name="{$URL}">
                           <xsl:value-of select="$PARAMS/string[@name='url']"/>
                        </xsl:element>
                        <xsl:copy-of select="$PARAMS"/>                    
                    </xsl:if>

                    <xsl:if test="$PARAMS_ALL/type = 'settings'">
                        <xsl:copy-of select="$PARAMS"/>                    
                    </xsl:if>

                       <xsl:copy-of select="$PARAMS_ALL/parser"/>
                </xsl:element> 
          </xsl:when>
          <xsl:otherwise>
              <xsl:element name="{$RESPONSE}">
                <xsl:attribute name="class">systemMessages</xsl:attribute>
                <xsl:attribute name="function">errorMessage</xsl:attribute>
                <xsl:element name="{'Params'}">
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">moduleName</xsl:attribute>
                        <xsl:text>facebook</xsl:text>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">code</xsl:attribute>
                        <xsl:text>201</xsl:text>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">text</xsl:attribute>
                        <xsl:text>Unable to perform request</xsl:text>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">comment</xsl:attribute>
                        <xsl:text>Request not supported</xsl:text>
                    </xsl:element> 									
                </xsl:element>
              </xsl:element>
          </xsl:otherwise>
    </xsl:choose> 
</xsl:template>

    <xsl:template match="Params">
        <xsl:param name="node"/>
                

            <xsl:choose>
                <xsl:when test="$node = 'id'">
                    <xsl:choose>
                        <xsl:when test="string-length(@id) != 0">
                            <xsl:value-of select="substring-after(@id, 'fb') "/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$MID"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="($node = 'albumId') or ($node = 'messageId') or ($node = 'photoId') or ($node='ownerId')">
                    <xsl:value-of select="substring-after(//*[@name=$node], 'fb') "/>
                </xsl:when>
                <xsl:when test="$node = 'timeOffset'">
                    <xsl:if test="number(//*[@name=$node])>0">
                        <xsl:text disable-output-escaping="yes">AND%20</xsl:text>
                        <xsl:value-of select="number(//*[@name=$node])"/>
                        <xsl:text disable-output-escaping="yes">>created_time</xsl:text>
                    </xsl:if>
                </xsl:when>
                <xsl:when test="$node = 'pageSize'">
		            <xsl:if test="//number[@name='pageSize']">
	                    <xsl:text>LIMIT%20</xsl:text>
	                    <xsl:value-of select="number(//number[@name=$node])"/>
		            </xsl:if>
                </xsl:when>
                <xsl:when test="$node = 'page'">
                    <xsl:if test="//number[@name='page']">
                        <xsl:if test="//number[@name='pageSize']">
		                    <xsl:text>OFFSET%20</xsl:text>
		                    <xsl:value-of select="number(//number[@name='pageSize'])*(number(//number[@name='page'])-1)"/>
		                </xsl:if>
                    </xsl:if>
                </xsl:when>
                <xsl:when test="$node = 'start'">
                     <xsl:choose>
		                <xsl:when test="//number[@name='page']">
		                    <xsl:value-of select="number(//number[@name='page'])"/>
		                </xsl:when>
		                <xsl:otherwise>
		                    <xsl:value-of select="'1'"/>
		                </xsl:otherwise>
                     </xsl:choose>
	                    <xsl:text>_</xsl:text>
                     <xsl:choose>
		                <xsl:when test="//number[@name='pageSize']">
		                    <xsl:value-of select="number(//number[@name='pageSize'])"/>
		                </xsl:when>
		                <xsl:otherwise>
		                    <xsl:value-of select="$LIMIT"/>
		                </xsl:otherwise>
                     </xsl:choose>
                </xsl:when>
                <xsl:when test="not(//*[@name=$node])">
                    <xsl:value-of select="$PARAMS_ALL/param[@select=$node]"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="//*[@name=$node]"/>
                </xsl:otherwise>
            </xsl:choose>

    </xsl:template>
    
    <xsl:template name="arg-replace">
      <xsl:param name="text" />
      <xsl:param name="replace" />
      <!--xsl:param name="type" /-->
      <xsl:variable name="rs" select="concat('%',$replace)"/>
      <xsl:choose>
        <xsl:when test="contains($text, $rs)">
        <xsl:value-of select="substring-before($text,$rs)" />
        <xsl:choose>
            <xsl:when test="$PARAMS_ALL/param[@id = $replace]/@select != '.'">
                <xsl:apply-templates select="$PARAMS">
                  <xsl:with-param name="node">
                      <xsl:value-of select="$PARAMS_ALL/param[@id = $replace]/@select"/>
                  </xsl:with-param>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$PARAMS_ALL/param[@id = $replace]/."/>
            </xsl:otherwise>
        </xsl:choose>
          <xsl:call-template name="arg-replace">
            <xsl:with-param name="text" select="substring-after($text,$rs)" />
            <xsl:with-param name="replace" select="$replace + 1" />
            <!--xsl:with-param name="type" select="param" /-->            
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
        <xsl:value-of select="$text" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:template>
    
    <xsl:template name="url-replace">
      <xsl:param name="text" />
      <xsl:param name="replace" />
      <xsl:variable name="rs" select="concat('%',$replace)"/>
      <xsl:choose>
        <xsl:when test="contains($text, $rs)">
        <xsl:value-of select="substring-before($text,$rs)" />
        <xsl:choose>
            <xsl:when test="$PARAMS_ALL/urlparam[@id = $replace]/@select != '.'">
                <xsl:apply-templates select="$PARAMS">
                  <xsl:with-param name="node">
                      <xsl:value-of select="$PARAMS_ALL/urlparam[@id = $replace]/@select"/>
                  </xsl:with-param>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$PARAMS_ALL/urlparam[@id = $replace]/."/>
            </xsl:otherwise>
        </xsl:choose>
          <xsl:call-template name="url-replace">
            <xsl:with-param name="text" select="substring-after($text,$rs)" />
            <xsl:with-param name="replace" select="$replace + 1" />
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
        <xsl:value-of select="$text" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:template>    
    
</xsl:stylesheet>
