<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
	 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  

<xsl:include href="errors.xsl"/>

<xsl:template match="/df:fql_multiquery_response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getPhotos</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">photosList</xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(/df:fql_multiquery_response/df:fql_result[df:name='photos']/df:fql_result_set/df:photo)"/>
                </xsl:attribute>
                <xsl:attribute name="ownerId">
                    <xsl:text>fb</xsl:text>
                    <xsl:value-of select="/df:fql_multiquery_response/df:fql_result[df:name='album']/df:fql_result_set/df:user/df:uid"/>
                </xsl:attribute>
                <xsl:attribute name="albumId">
                    <xsl:text>fb</xsl:text>
                    <xsl:value-of select="/df:fql_multiquery_response/df:fql_result[df:name='album']/df:fql_result_set/df:user/df:anon"/>
                </xsl:attribute>
                <xsl:apply-templates select="/df:fql_multiquery_response/df:fql_result[df:name='photos']/df:fql_result_set/df:photo"/>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>


<xsl:template match="df:photo">

    <xsl:element name="{$STRUCT}">
        <xsl:attribute name="name">photo</xsl:attribute>
        <xsl:attribute name="id">
            <xsl:text>fb</xsl:text>
        <xsl:value-of select="df:pid"/>
        </xsl:attribute>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">albumId</xsl:attribute>
            <xsl:text>fb</xsl:text>
            <xsl:value-of select="df:aid"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">ownerId</xsl:attribute>
            <xsl:text>fb</xsl:text>
            <xsl:value-of select="df:owner"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
           <xsl:attribute name="name">urlSmall</xsl:attribute>
           <xsl:value-of select="df:src"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">urlBig</xsl:attribute>
            <xsl:value-of select="df:src_big"/>
        </xsl:element>

        <xsl:element name="{$NUMBER}">
            <xsl:attribute name="name">created</xsl:attribute>
            <xsl:value-of select="df:created"/>
        </xsl:element>

        <xsl:element name="{$NUMBER}">
            <xsl:attribute name="name">modified</xsl:attribute>
            <xsl:value-of select="df:modified"/>
        </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
