/*
 * This file is part of libdicto
 *
 * Copyright (C) 2007-2009 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _DICTO_H
#define _DICTO_H

#include <gtk/gtk.h>
#include <gst/gst.h>

G_BEGIN_DECLS

#define DICTO_TYPE				(dicto_get_type ())
#define DICTO(obj)				(G_TYPE_CHECK_INSTANCE_CAST ((obj), DICTO_TYPE, Dicto))
#define DICTO_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), DICTO_TYPE, DictoClass))
#define IS_DICTO(obj)			(G_TYPE_CHECK_INSTANCE_TYPE ((obj), DICTO_TYPE))
#define IS_DICTO_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), DICTO_TYPE))
#define DICTO_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS ((obj), DICTO_TYPE, DictoClass))

typedef enum {
	FORMAT_DEFAULT,
	FORMAT_WAV_11K_8B_M,
	FORMAT_WAV_11K_16B_M,
	FORMAT_WAV_22K_8B_M,
	FORMAT_WAV_22K_16B_M,
	FORMAT_WAV_44K_8B_M,
	FORMAT_WAV_44K_16B_M,
	FORMAT_WAV_44K_16B_S,
	FORMAT_SPX_SPEEX,
	FORMAT_WAV_ALAW,
	FORMAT_WAV_MULAW,
	FORMAT_WAV_8K_16B_M,
	FORMAT_VORBIS,
	FORMAT_LAST,
} DictoFormat;

typedef struct _dicto Dicto;
struct _dicto {
	GObject parent;

	/* Private */
	gpointer priv;
};

typedef struct _DictoClass DictoClass;
struct _DictoClass {
	GObjectClass parent;

	void (*started_play) (Dicto *dicto, gpointer data);
	void (*stopped_play) (Dicto *dicto, gpointer data);
	void (*started_record) (Dicto *dicto, gpointer data);
	void (*stopped_record) (Dicto *dicto, gpointer data);
	void (*error) (Dicto *dicto, gpointer data);
	void (*position_update) (Dicto *dicto, gdouble pos, gpointer data);
	void (*refresh) (Dicto *dicto, gpointer data);
	void (*ready) (Dicto *dicto, gpointer data);
	void (*level) (Dicto *dicto, gdouble level, gpointer data);
};

GType dicto_get_type(void);

Dicto *dicto_new(gchar *basedir);
Dicto *dicto_new_full(gchar *basedir, DictoFormat f, gchar *sink, gchar *source);

gboolean dicto_set_basedir(Dicto *d, const gchar *basedir);

gboolean dicto_record(Dicto *d, const gchar *file);
gboolean dicto_record_timeout(Dicto *d, const gchar *file, gdouble secs);
gboolean dicto_toggle_record(Dicto *d, const gchar *file);

gboolean dicto_prepare(Dicto *d, const gchar *file);
gboolean dicto_play(Dicto *d, const gchar *file);

gboolean dicto_stop(Dicto *d);
gboolean dicto_seek(Dicto *d, gdouble pos);
gboolean dicto_delete(Dicto *d, const gchar *file);

gchar *dicto_filename_time_new(Dicto *d, time_t t);

gboolean dicto_refresh_list(Dicto *d);
GHashTable *dicto_notes_get_list(Dicto *d);
gboolean dicto_remove(Dicto *d, const gchar *file);

gboolean dicto_get_position(Dicto *d, gdouble *length, gdouble *position);

G_END_DECLS

#endif
