/*
 * This file is part of libdicto
 *
 * Copyright (C) 2007-2009 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _DICTO_UI_H
#define _DICTO_UI_H

#include <gtk/gtk.h>
#include <gst/gst.h>
#include "dicto.h"

G_BEGIN_DECLS

#define DICTO_WIDGET_TYPE		(dicto_widget_get_type ())
#define DICTO_WIDGET(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), DICTO_WIDGET_TYPE, DictoWidget))
#define DICTO_WIDGET_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), DICTO_WIDGET_TYPE, DictoWidgetClass))
#define IS_DICTO_WIDGET(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), DICTO_WIDGET_TYPE))

typedef struct _DictoWidget DictoWidget;
struct _DictoWidget {
	GtkHBox parent_widget;
	gpointer priv;
};

typedef struct _DictoWidgetClass DictoWidgetClass;
struct _DictoWidgetClass {
	GtkHBoxClass parent_class;
	gboolean (*delete_query) (DictoWidget *dicto, gchar *file, gpointer data);
};

DictoWidget *dicto_widget_new(Dicto *d);
Dicto *dicto_widget_get_dicto(DictoWidget *dw);

gboolean dicto_widget_delete_query_dialog(GtkWindow *w, const gchar *file);

G_END_DECLS

#endif
