/*
 * Copyright (C) 2010 Corentin Chary <corentin.chary@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STATIONS_SIMPLE_PRIVATE_LONDON_H
#define STATIONS_SIMPLE_PRIVATE_LONDON_H

#include "stationspluginsimple_p.h"


static const struct {
        int number;
        int arrondissementNumber;
        const char *name;
        const char *address;
        double x;
        double y;
} stations[] = {
	{ 1, 0, "River Street , Clerkenwell", "", 51.529163, -0.109971 },
	{ 2, 0, "Phillimore Gardens, Kensington", "", 51.499607, -0.197574 },
	{ 3, 0, "Christopher Street, Liverpool Street", "", 51.521284, -0.084606 },
	{ 4, 0, "St. Chad'S Street, King'S Cross", "", 51.530059, -0.120974 },
	{ 5, 0, "George Place Mews, Marylebone", "", 51.516893, -0.158250 },
	{ 6, 0, "Broadcasting House, Marylebone", "", 51.518118, -0.144229 },
	{ 7, 0, "Charlbert Street, St. John'S Wood", "", 51.534300, -0.168074 },
	{ 8, 0, "Lodge Road, St. John'S Wood", "", 51.528341, -0.170134 },
	{ 9, 0, "New Globe Walk, Bankside", "", 51.507385, -0.096441 },
	{ 10, 0, "Park Street, Bankside", "", 51.505974, -0.092754 },
	{ 11, 0, "Brunswick Square, Bloomsbury", "", 51.523951, -0.122502 },
	{ 12, 0, "Malet Street, Bloomsbury", "", 51.521681, -0.130432 },
	{ 13, 0, "Scala Street, Fitzrovia", "", 51.519915, -0.136040 },
	{ 14, 0, "Belgrove Street , King'S Cross", "", 51.529944, -0.123617 },
	{ 15, 0, "Great Russell Street, Bloomsbury", "", 51.517727, -0.127854 },
	{ 16, 0, "Cartwright Gardens , Bloomsbury", "", 51.526358, -0.125979 },
	{ 17, 0, "Hatton Wall, Holborn", "", 51.521661, -0.109006 },
	{ 18, 0, "Drury Lane, Covent Garden", "", 51.514771, -0.122220 },
	{ 19, 0, "Taviton Street, Bloomsbury", "", 51.525051, -0.131161 },
	{ 20, 0, "Drummond Street , Euston", "", 51.527736, -0.135273 },
	{ 21, 0, "Hampstead Road (Cartmel), Euston", "", 51.530078, -0.138846 },
	{ 22, 0, "Northington Street , Holborn", "", 51.522264, -0.114079 },
	{ 23, 0, "Red Lion Square, Holborn", "", 51.519435, -0.119123 },
	{ 24, 0, "British Museum, Bloomsbury", "", 51.519080, -0.124678 },
	{ 25, 0, "Doric Way , Somers Town", "", 51.528834, -0.132250 },
	{ 26, 0, "Ampton Street , Clerkenwell", "", 51.527281, -0.118295 },
	{ 27, 0, "Bouverie Street, Temple", "", 51.513821, -0.107928 },
	{ 28, 0, "Bolsover Street, Fitzrovia", "", 51.523518, -0.143614 },
	{ 29, 0, "Eversholt Street , Camden Town", "", 51.533005, -0.136793 },
	{ 30, 0, "Windsor Terrace, Hoxton", "", 51.529154, -0.093422 },
	{ 31, 0, "Fanshaw Street, Hoxton", "", 51.529537, -0.083353 },
	{ 32, 0, "Leonard Circus , Shoreditch", "", 51.524696, -0.084439 },
	{ 33, 0, "Altab Ali Park, Whitechapel", "", 51.516816, -0.067828 },
	{ 34, 0, "Pancras Road, King'S Cross", "", 51.534123, -0.129387 },
	{ 35, 0, "St. George Street, Mayfair", "", 51.511960, -0.142783 },
	{ 36, 0, "De Vere Gardens, Kensington", "", 51.501737, -0.184981 },
	{ 37, 0, "Penywern Road, Earl'S Court", "", 51.491594, -0.192369 },
	{ 38, 0, "Abingdon Villas, Kensington", "", 51.497388, -0.197246 },
	{ 39, 0, "Shoreditch High Street, Shoreditch", "", 51.526378, -0.078131 },
	{ 40, 0, "Commercial Street, Shoreditch", "", 51.521271, -0.075579 },
	{ 41, 0, "Sun Street, Liverpool Street", "", 51.520017, -0.083911 },
	{ 42, 0, "Wenlock Road , Hoxton", "", 51.530992, -0.093904 },
	{ 43, 0, "Crawford Street, Marylebone", "", 51.520260, -0.157184 },
	{ 44, 0, "Bruton Street, Mayfair", "", 51.510737, -0.144165 },
	{ 45, 0, "Harewood Avenue, Marylebone", "", 51.522320, -0.163849 },
	{ 46, 0, "Penfold Street, Marylebone", "", 51.522892, -0.171682 },
	{ 47, 0, "Warwick Avenue Station, Maida Vale", "", 51.523345, -0.183846 },
	{ 48, 0, "Godliman Street, St. Paul'S", "", 51.512484, -0.099141 },
	{ 49, 0, "Curzon Street, Mayfair", "", 51.507069, -0.145904 },
	{ 50, 0, "East Road, Hoxton", "", 51.528673, -0.087459 },
	{ 51, 0, "Finsbury Library , Finsbury", "", 51.526718, -0.104298 },
	{ 52, 0, "Roscoe Street, St. Luke'S", "", 51.522954, -0.094935 },
	{ 53, 0, "Grafton Street, Mayfair", "", 51.509992, -0.143495 },
	{ 54, 0, "Golden Lane, Barbican", "", 51.521748, -0.094475 },
	{ 55, 0, "Finsbury Circus, Liverpool Street", "", 51.517075, -0.086686 },
	{ 56, 0, "Paddington Street, Marylebone", "", 51.520584, -0.154701 },
	{ 57, 0, "Guilford Street , Bloomsbury", "", 51.523347, -0.120203 },
	{ 58, 0, "New Inn Yard, Shoreditch", "", 51.524527, -0.079248 },
	{ 59, 0, "Rodney Street, Angel", "", 51.531768, -0.114329 },
	{ 60, 0, "Lisson Grove, St. John'S Wood", "", 51.526448, -0.172191 },
	{ 61, 0, "Great Dover Street, Borough", "", 51.497383, -0.089447 },
	{ 62, 0, "Cotton Garden Estate, Kennington", "", 51.490758, -0.106324 },
	{ 63, 0, "Murray Grove , Hoxton", "", 51.530890, -0.089783 },
	{ 64, 0, "William Iv Street, Strand", "", 51.509462, -0.124749 },
	{ 65, 0, "Gower Place , Euston", "", 51.525228, -0.135189 },
	{ 66, 0, "Holborn Circus, Holborn", "", 51.517950, -0.108657 },
	{ 67, 0, "Hatton Garden, Holborn", "", 51.518826, -0.108028 },
	{ 68, 0, "Theobalds Road , Holborn", "", 51.520597, -0.116688 },
	{ 69, 0, "Euston Road, Euston", "", 51.526236, -0.134408 },
	{ 70, 0, "Calshot Street , King'S Cross", "", 51.531361, -0.117070 },
	{ 71, 0, "Newgate Street , St. Paul'S", "", 51.515419, -0.098851 },
	{ 72, 0, "Farringdon Lane, Clerkenwell", "", 51.523520, -0.108340 },
	{ 73, 0, "Old Street Station, St. Luke'S", "", 51.525726, -0.088486 },
	{ 74, 0, "Vauxhall Cross, Vauxhall", "", 51.485917, -0.124470 },
	{ 75, 0, "Torrens Street, Angel", "", 51.532200, -0.105481 },
	{ 76, 0, "Longford Street, Regent'S Park", "", 51.525595, -0.144084 },
	{ 77, 0, "Russell Square Station, Bloomsbury", "", 51.523418, -0.124122 },
	{ 78, 0, "Sadlers Sports Centre, Finsbury", "", 51.524869, -0.099489 },
	{ 79, 0, "Wansey Street, Walworth", "", 51.491181, -0.097146 },
	{ 80, 0, "Webber Street , Southwark", "", 51.500694, -0.102091 },
	{ 81, 0, "Great Titchfield Street, Fitzrovia", "", 51.520253, -0.141327 },
	{ 82, 0, "Gloucester Road Station, South Kensington", "", 51.494186, -0.182671 },
	{ 83, 0, "Panton Street, West End", "", 51.509639, -0.131511 },
	{ 84, 0, "Breams Buildings, Holborn", "", 51.515937, -0.111778 },
	{ 85, 0, "Tanner Street, Bermondsey", "", 51.500647, -0.078600 },
	{ 86, 0, "Sancroft Street, Vauxhall", "", 51.489479, -0.115157 },
	{ 87, 0, "Devonshire Square, Liverpool Street", "", 51.516468, -0.079685 },
	{ 88, 0, "Bayley Street , Bloomsbury", "", 51.518588, -0.132053 },
	{ 89, 0, "Tavistock Place, Bloomsbury", "", 51.526250, -0.123510 },
	{ 90, 0, "Harrington Square, Camden Town", "", 51.533019, -0.139175 },
	{ 91, 0, "Walnut Tree Walk, Vauxhall", "", 51.493686, -0.111015 },
	{ 92, 0, "Borough Road, Elephant & Castle", "", 51.498898, -0.100441 },
	{ 93, 0, "Cloudesley Road, Angel", "", 51.534409, -0.109025 },
	{ 94, 0, "Bricklayers Arms, Borough", "", 51.495061, -0.085814 },
	{ 95, 0, "Aldersgate Street, Barbican", "", 51.520842, -0.097340 },
	{ 96, 0, "Falkirk Street, Hoxton", "", 51.530951, -0.078505 },
	{ 97, 0, "Gloucester Road (North), Kensington", "", 51.497925, -0.183835 },
	{ 98, 0, "Hampstead Road, Euston", "", 51.525542, -0.138231 },
	{ 99, 0, "Old Quebec Street, Marylebone", "", 51.514578, -0.158264 },
	{ 100, 0, "Albert Embankment, Vauxhall", "", 51.490436, -0.122807 },
	{ 101, 0, "Queen Street, Bank", "", 51.511553, -0.092940 },
	{ 102, 0, "Jewry Street, Aldgate", "", 51.513407, -0.076793 },
	{ 103, 0, "Vicarage Gate, Kensington", "", 51.504724, -0.192539 },
	{ 105, 0, "Westbourne Grove, Bayswater", "", 51.515530, -0.190241 },
	{ 106, 0, "Woodstock Street, Mayfair", "", 51.514105, -0.147302 },
	{ 107, 0, "Finsbury Leisure Centre, St. Luke'S", "", 51.526008, -0.096318 },
	{ 108, 0, "Abbey Orchard Street, Westminster", "", 51.498126, -0.132102 },
	{ 109, 0, "Soho Square , Soho", "", 51.515631, -0.132329 },
	{ 110, 0, "Wellington Road, St. John'S Wood", "", 51.533043, -0.172529 },
	{ 111, 0, "Park Lane , Hyde Park", "", 51.510017, -0.157276 },
	{ 112, 0, "Stonecutter Street, Holborn", "", 51.515810, -0.105270 },
	{ 113, 0, "Gloucester Road (Central), South Kensington", "", 51.496463, -0.183289 },
	{ 114, 0, "Park Road (Baker Street), Regent'S Park", "", 51.524517, -0.158964 },
	{ 115, 0, "Braham Street, Aldgate", "", 51.514234, -0.073538 },
	{ 116, 0, "Little Argyll Street, West End", "", 51.514500, -0.141424 },
	{ 117, 0, "Lollard Street, Vauxhall", "", 51.492881, -0.114934 },
	{ 118, 0, "Rochester Row, Westminster", "", 51.495827, -0.135478 },
	{ 119, 0, "Bath Street, St. Luke'S", "", 51.525893, -0.090848 },
	{ 120, 0, "The Guildhall, Guildhall", "", 51.515735, -0.093081 },
	{ 121, 0, "Baker Street, Marylebone", "", 51.518913, -0.156167 },
	{ 122, 0, "Norton Folgate, Liverpool Street", "", 51.521114, -0.078870 },
	{ 123, 0, "St. John Street, Finsbury", "", 51.528360, -0.104725 },
	{ 124, 0, "Eaton Square, Belgravia", "", 51.496545, -0.150905 },
	{ 125, 0, "Borough High Street, The Borough", "", 51.500695, -0.094524 },
	{ 126, 0, "Museum Of London, Barbican", "", 51.517821, -0.096497 },
	{ 127, 0, "Wood Street, Guildhall", "", 51.517008, -0.093885 },
	{ 128, 0, "Emperor'S Gate, South Kensington", "", 51.495362, -0.185297 },
	{ 129, 0, "Golden Square, Soho", "", 51.511897, -0.137044 },
	{ 130, 0, "Tower Gardens , Tower", "", 51.509506, -0.075459 },
	{ 131, 0, "Natural History Museum, South Kensington", "", 51.495593, -0.179078 },
	{ 132, 0, "Bethnal Green Road, Shoreditch", "", 51.523648, -0.074755 },
	{ 133, 0, "Derry Street, Kensington", "", 51.501365, -0.191462 },
	{ 134, 0, "Wapping High Street, Wapping", "", 51.504822, -0.067821 },
	{ 135, 0, "Clerkenwell Green, Clerkenwell", "", 51.523260, -0.104709 },
	{ 136, 0, "Queen Victoria Street, St. Paul'S", "", 51.511962, -0.097442 },
	{ 137, 0, "Bourne Street, Belgravia", "", 51.490875, -0.153320 },
	{ 138, 0, "Green Street, Mayfair", "", 51.512276, -0.157437 },
	{ 139, 0, "Lambeth Road, Vauxhall", "", 51.494881, -0.117975 },
	{ 140, 0, "Finsbury Square , Moorgate", "", 51.520963, -0.085634 },
	{ 141, 0, "Chapel Place, Marylebone", "", 51.515308, -0.147204 },
	{ 142, 0, "West Cromwell Road, Earl'S Court", "", 51.493725, -0.198287 },
	{ 143, 0, "Pont Street, Knightsbridge", "", 51.496887, -0.161204 },
	{ 144, 0, "Kennington Cross, Kennington", "", 51.488940, -0.111436 },
	{ 145, 0, "Ilchester Place, Kensington", "", 51.500744, -0.202759 },
	{ 146, 0, "Vauxhall Bridge , Pimlico", "", 51.488365, -0.129362 },
	{ 147, 0, "Portugal Street, Holborn", "", 51.514943, -0.116146 },
	{ 148, 0, "Turquoise Island, Notting Hill", "", 51.514312, -0.200838 },
	{ 149, 0, "Kennington Road Post Office, Oval", "", 51.484789, -0.110683 },
	{ 150, 0, "Holy Trinity Brompton, Knightsbridge", "", 51.497056, -0.168917 },
	{ 151, 0, "Chepstow Villas, Notting Hill", "", 51.512137, -0.201555 },
	{ 152, 0, "Hampton Street, Walworth", "", 51.492170, -0.101537 },
	{ 153, 0, "Bayswater Road, Hyde Park", "", 51.511834, -0.174293 },
	{ 154, 0, "Howick Place, Westminster", "", 51.496753, -0.138734 },
	{ 155, 0, "Lexham Gardens, Kensington", "", 51.495867, -0.191934 },
	{ 156, 0, "New Kent Road, Borough", "", 51.494436, -0.092921 },
	{ 157, 0, "Wright'S Lane, Kensington", "", 51.500398, -0.193068 },
	{ 158, 0, "Trebovir Road, Earl'S Court", "", 51.490854, -0.196170 },
	{ 159, 0, "Great Marlborough Street, Soho", "", 51.514620, -0.137841 },
	{ 160, 0, "Waterloo Place, St. James'S", "", 51.506633, -0.131774 },
	{ 161, 0, "Guildhouse Street, Victoria", "", 51.492346, -0.141334 },
	{ 162, 0, "Southampton Place, Holborn", "", 51.517607, -0.121328 },
	{ 163, 0, "Sloane Avenue, Knightsbridge", "", 51.493185, -0.167895 },
	{ 164, 0, "Cleveland Gardens, Bayswater", "", 51.515607, -0.183119 },
	{ 165, 0, "Orsett Terrace, Bayswater", "", 51.517932, -0.183717 },
	{ 166, 0, "Seville Street, Knightsbridge", "", 51.501855, -0.159237 },
	{ 167, 0, "Eccleston Place, Victoria", "", 51.493951, -0.147624 },
	{ 168, 0, "Argyll Road, Kensington", "", 51.500401, -0.195456 },
	{ 169, 0, "Porchester Place, Paddington", "", 51.514746, -0.165164 },
	{ 170, 0, "Hardwick Street, Clerkenwell", "", 51.527843, -0.108068 },
	{ 171, 0, "Collingham Gardens, Earl'S Court", "", 51.491616, -0.186754 },
	{ 172, 0, "Sumner Place, South Kensington", "", 51.491212, -0.173716 },
	{ 173, 0, "Tachbrook Street, Victoria", "", 51.492111, -0.138365 },
	{ 174, 0, "Cheapside, Bank", "", 51.513891, -0.093118 },
	{ 175, 0, "Appold Street, Liverpool Street", "", 51.521744, -0.081119 },
	{ 176, 0, "Gloucester Terrace, Bayswater", "", 51.517919, -0.188099 },
	{ 177, 0, "Ashley Place, Victoria", "", 51.496161, -0.140948 },
	{ 178, 0, "Warwick Square, Pimlico", "", 51.489856, -0.141924 },
	{ 179, 0, "Pall Mall , St. James'S", "", 51.505735, -0.136707 },
	{ 180, 0, "North Audley Street, Mayfair", "", 51.512912, -0.153645 },
	{ 181, 0, "Belgrave Square, Belgravia", "", 51.499412, -0.152318 },
	{ 182, 0, "Bell Street , Marylebone", "", 51.522029, -0.165843 },
	{ 183, 0, "Milford Lane, Temple", "", 51.512010, -0.112988 },
	{ 184, 0, "Portland Place, Marylebone", "", 51.520715, -0.145212 },
	{ 185, 0, "Alderney Street, Pimlico", "", 51.488058, -0.140741 },
	{ 186, 0, "South Wharf Road, Paddington", "", 51.517336, -0.175811 },
	{ 187, 0, "Queen'S Gate (South), South Kensington", "", 51.492480, -0.178433 },
	{ 188, 0, "Nutford Place, Marylebone", "", 51.516518, -0.164394 },
	{ 189, 0, "Claremont Square, Angel", "", 51.531667, -0.109915 },
	{ 190, 0, "Rampayne Street, Pimlico", "", 51.489976, -0.132846 },
	{ 191, 0, "Hyde Park Corner, Hyde Park", "", 51.503118, -0.153521 },
	{ 192, 0, "Wardour Street, Soho", "", 51.512515, -0.133202 },
	{ 193, 0, "Bankside Mix, Bankside", "", 51.505818, -0.100186 },
	{ 194, 0, "Hop Exchange, The Borough", "", 51.504628, -0.091774 },
	{ 195, 0, "Milroy Walk, South Bank", "", 51.507244, -0.106238 },
	{ 196, 0, "Union Street, The Borough", "", 51.503688, -0.098498 },
	{ 197, 0, "Stamford Street, South Bank", "", 51.505569, -0.111607 },
	{ 199, 0, "Great Tower Street, Monument", "", 51.510485, -0.082990 },
	{ 200, 0, "Lmu Commercial Road, Whitechapel", "", 51.514925, -0.066078 },
	{ 201, 0, "Dorset Square, Marylebone", "", 51.522596, -0.161113 },
	{ 202, 0, "Leman Street, Aldgate", "", 51.512364, -0.069542 },
	{ 203, 0, "West Smithfield Rotunda, Farringdon", "", 51.518219, -0.100791 },
	{ 204, 0, "Margery Street, Clerkenwell", "", 51.526600, -0.112433 },
	{ 205, 0, "New Road  2, Whitechapel", "", 51.518144, -0.062750 },
	{ 206, 0, "New Road 1 , Whitechapel", "", 51.518154, -0.062697 },
	{ 207, 0, "Grosvenor Crescent, Belgravia", "", 51.501353, -0.153195 },
	{ 208, 0, "Mallory Street, Marylebone", "", 51.525052, -0.166304 },
	{ 209, 0, "Denyer Street, Knightsbridge", "", 51.493584, -0.165101 },
	{ 210, 0, "Hinde Street, Marylebone", "", 51.516814, -0.151926 },
	{ 211, 0, "Cadogan Place, Knightsbridge", "", 51.494645, -0.158106 },
	{ 212, 0, "Campden Hill Road, Notting Hill", "", 51.506585, -0.199004 },
	{ 213, 0, "Wellington Arch, Hyde Park", "", 51.502740, -0.149569 },
	{ 214, 0, "Endsleigh Gardens, Euston", "", 51.526838, -0.130504 },
	{ 215, 0, "Moorfields, Moorgate", "", 51.519069, -0.088285 },
	{ 216, 0, "Old Brompton Road, South Kensington", "", 51.490946, -0.181191 },
	{ 217, 0, "Wormwood Street, Liverpool Street", "", 51.516155, -0.082422 },
	{ 218, 0, "St. Luke'S Church, Chelsea", "", 51.489717, -0.170194 },
	{ 219, 0, "Bramham Gardens, Earl'S Court", "", 51.490164, -0.190394 },
	{ 220, 0, "Chelsea Green, Chelsea", "", 51.490665, -0.166485 },
	{ 221, 0, "Horseferry Road, Westminster", "", 51.494816, -0.130459 },
	{ 222, 0, "Knightsbridge, Hyde Park", "", 51.502757, -0.155350 },
	{ 223, 0, "Rodney Road , Walworth", "", 51.491485, -0.090221 },
	{ 224, 0, "Whiteley'S, Bayswater", "", 51.514770, -0.188130 },
	{ 225, 0, "Notting Hill Gate Station, Notting Hill", "", 51.509359, -0.196397 },
	{ 226, 0, "Charles Ii Street, West End", "", 51.508446, -0.131961 },
	{ 227, 0, "Great Percy Street, Clerkenwell", "", 51.528916, -0.115481 },
	{ 228, 0, "St. James'S Square, St. James'S", "", 51.507425, -0.134621 },
	{ 229, 0, "Whitehall Place, Strand", "", 51.506543, -0.123180 },
	{ 230, 0, "Poured Lines, Bankside", "", 51.506693, -0.103137 },
	{ 231, 0, "Queen'S Gate (Central), South Kensington", "", 51.493968, -0.178732 },
	{ 232, 0, "Carey Street, Holborn", "", 51.515010, -0.112753 },
	{ 233, 0, "Pall Mall East, West End", "", 51.507770, -0.130700 },
	{ 234, 0, "Liverpool Road (N1 Centre), Angel", "", 51.534504, -0.106993 },
	{ 235, 0, "Kennington Road  , Vauxhall", "", 51.495718, -0.110889 },
	{ 236, 0, "Fashion Street, Whitechapel", "", 51.518380, -0.073439 },
	{ 237, 0, "Vaughan Way, Wapping", "", 51.508445, -0.067176 },
	{ 238, 0, "Frampton Street, Paddington", "", 51.523353, -0.175116 },
	{ 239, 0, "Warren Street Station, Euston", "", 51.524438, -0.138019 },
	{ 240, 0, "Colombo Street, Southwark", "", 51.505459, -0.105692 },
	{ 241, 0, "Eaton Gate, Belgravia", "", 51.494165, -0.154606 },
	{ 242, 0, "Beaumont Street, Marylebone", "", 51.522008, -0.151359 },
	{ 243, 0, "Gloucester Street, Pimlico", "", 51.490963, -0.139625 },
	{ 244, 0, "Earnshaw Street , Covent Garden", "", 51.516119, -0.128585 },
	{ 245, 0, "Grosvenor Road, Pimlico", "", 51.485357, -0.142207 },
	{ 246, 0, "Berry Street, Clerkenwell", "", 51.522853, -0.099994 },
	{ 247, 0, "St. John'S Wood Church, Regent'S Park", "", 51.530052, -0.168314 },
	{ 248, 0, "Triangle Car Park, Hyde Park", "", 51.506452, -0.170280 },
	{ 249, 0, "Harper Road, Borough", "", 51.498598, -0.096191 },
	{ 250, 0, "Royal Avenue 1, Chelsea", "", 51.489932, -0.162727 },
	{ 251, 0, "Brushfield Street, Liverpool Street", "", 51.518908, -0.079249 },
	{ 252, 0, "Jubilee Gardens, South Bank", "", 51.504636, -0.116542 },
	{ 253, 0, "Shoreditch Park, Hoxton", "", 51.534043, -0.086380 },
	{ 254, 0, "Chadwell Street, Angel", "", 51.530516, -0.106408 },
	{ 255, 0, "Clifton Road, Maida Vale", "", 51.525575, -0.179593 },
	{ 256, 0, "Houghton Street, Strand", "", 51.513621, -0.116764 },
	{ 257, 0, "Westminster University, Marylebone", "", 51.522482, -0.154907 },
	{ 258, 0, "Kensington Gore, Knightsbridge", "", 51.501433, -0.178657 },
	{ 260, 0, "Broadwick Street, Soho", "", 51.513685, -0.135581 },
	{ 261, 0, "Princes Square, Bayswater", "", 51.513489, -0.191351 },
	{ 262, 0, "Lsbu (Borough Road), Elephant & Castle", "", 51.498745, -0.103133 },
	{ 263, 0, "St. Mary Axe, Aldgate", "", 51.514225, -0.080660 },
	{ 264, 0, "Tysoe Street, Clerkenwell", "", 51.526443, -0.109257 },
	{ 265, 0, "Southwick Street, Paddington", "", 51.515953, -0.169249 },
	{ 266, 0, "Queen'S Gate (North), Kensington", "", 51.501027, -0.180246 },
	{ 267, 0, "Regency Street, Westminster", "", 51.492060, -0.132225 },
	{ 268, 0, "Belgrave Road, Victoria", "", 51.493204, -0.144133 },
	{ 269, 0, "Empire Square, The Borough", "", 51.500823, -0.089741 },
	{ 270, 0, "Kennington Lane Rail Bridge, Vauxhall", "", 51.486343, -0.122492 },
	{ 271, 0, "London Zoo Entrance Car Park", "", 51.535836, -0.156285 },
	{ 272, 0, "Baylis Road, Waterloo", "", 51.501445, -0.110699 },
	{ 273, 0, "Belvedere Road, South Bank", "", 51.506133, -0.114686 },
	{ 274, 0, "Warwick Road, Olympia", "", 51.496712, -0.205284 },
	{ 275, 0, "Barbican Centre, Barbican", "", 51.520045, -0.092176 },
	{ 276, 0, "Lower Thames Street, Monument", "", 51.509302, -0.084985 },
	{ 277, 0, "Kensington Church Street, Kensington", "", 51.503157, -0.191496 },
	{ 278, 0, "Tooley Street, Bermondsey", "", 51.503494, -0.079621 },
	{ 279, 0, "North Wharf Road, Paddington", "", 51.518622, -0.176646 },
	{ 280, 0, "Royal Avenue 2, Chelsea", "", 51.490083, -0.162418 },
	{ 281, 0, "Smith Square, Westminster", "", 51.495806, -0.127575 },
	{ 282, 0, "Royal London Hospital, Whitechapel", "", 51.519064, -0.059642 },
	{ 283, 0, "Kingsway, Covent Garden", "", 51.514409, -0.118479 },
	{ 284, 0, "Lambeth North Station, Waterloo", "", 51.499141, -0.112031 },
	{ 285, 0, "Royal Mews, Victoria", "", 51.497966, -0.143822 },
	{ 286, 0, "St. John'S Wood Road, St. John'S Wood", "", 51.527295, -0.174654 },
	{ 287, 0, "Bedford Way, Bloomsbury", "", 51.523673, -0.128378 },
	{ 288, 0, "Elizabeth Bridge, Victoria", "", 51.492370, -0.147479 },
	{ 289, 0, "South Audley Street, Mayfair", "", 51.509230, -0.151296 },
	{ 290, 0, "Winsland Street, Paddington", "", 51.516780, -0.175489 },
	{ 291, 0, "Claverton Street, Pimlico", "", 51.484840, -0.138089 },
	{ 292, 0, "Montpelier Street, Knightsbridge", "", 51.498884, -0.165472 },
	{ 293, 0, "Kensington Olympia Station, Olympia", "", 51.498158, -0.209494 },
	{ 294, 0, "St. George'S Square, Pimlico", "", 51.488226, -0.135636 },
	{ 295, 0, "Swan Street, The Borough", "", 51.500296, -0.092763 },
	{ 296, 0, "Knaresborough Place, Earl'S Court", "", 51.493632, -0.190603 },
	{ 297, 0, "Geraldine Street, Elephant & Castle", "", 51.496128, -0.106001 },
	{ 298, 0, "Curlew Street, Shad Thames", "", 51.502280, -0.074189 },
	{ 299, 0, "Vincent Square, Westminster", "", 51.493985, -0.136929 },
	{ 300, 0, "Serpentine Car Park, Hyde Park", "", 51.505014, -0.172730 },
	{ 301, 0, "Marylebone Lane, Marylebone", "", 51.514760, -0.148105 },
	{ 302, 0, "Fore Street Avenue, Guildhall", "", 51.517920, -0.090425 },
	{ 303, 0, "Albert Gate, Hyde Park", "", 51.502954, -0.158456 },
	{ 304, 0, "Cumberland Gate, Hyde Park", "", 51.512119, -0.162098 },
	{ 305, 0, "Kennington Lane Tesco, Vauxhall", "", 51.486780, -0.115854 },
	{ 307, 0, "Black Lion Gate, Kensington Gardens", "", 51.509908, -0.187843 },
	{ 308, 0, "Long Lane , Bermondsey", "", 51.499076, -0.085666 },
	{ 309, 0, "Embankment (Savoy), Strand", "", 51.509631, -0.119048 },
	{ 310, 0, "Black Prince Road, Vauxhall", "", 51.490868, -0.116912 },
	{ 311, 0, "Foley Street, Fitzrovia", "", 51.519181, -0.140486 },
	{ 312, 0, "Grove End Road, St. John'S Wood", "", 51.530889, -0.176771 },
	{ 313, 0, "Wells Street, Fitzrovia", "", 51.517344, -0.138073 },
	{ 314, 0, "Tyers Gate, Bermondsey", "", 51.500889, -0.083159 },
	{ 315, 0, "The Tennis Courts, Regent'S Park", "", 51.525367, -0.153464 },
	{ 316, 0, "Palace Gate, Kensington Gardens", "", 51.502042, -0.184400 },
	{ 317, 0, "Dickens Square, Borough", "", 51.496791, -0.093913 },
	{ 318, 0, "Sackville Street, Mayfair", "", 51.510048, -0.138846 },
	{ 319, 0, "Baldwin Street, St. Luke'S", "", 51.527026, -0.088543 },
	{ 320, 0, "Queen Mother Sports Centre, Victoria", "", 51.493574, -0.139956 },
	{ 321, 0, "Bermondsey Street, Bermondsey", "", 51.497856, -0.081608 },
	{ 322, 0, "Speakers' Corner 1, Hyde Park", "", 51.512220, -0.160785 },
	{ 323, 0, "Speakers' Corner 2, Hyde Park", "", 51.512303, -0.159988 },
	{ 324, 0, "Ontario Street, Elephant & Castle", "", 51.496520, -0.101384 },
	{ 325, 0, "St. Martin'S Street, West End", "", 51.509087, -0.129698 },
	{ 326, 0, "Graham Street, Angel", "", 51.532662, -0.099981 },
	{ 327, 0, "New North Road 1, Hoxton", "", 51.531140, -0.086016 },
	{ 328, 0, "New North Road 2, Hoxton", "", 51.530950, -0.085603 },
	{ 329, 0, "Prince Albert Road, Regent'S Park", "", 51.535893, -0.160854 },
	{ 330, 0, "Eastbourne Mews, Paddington", "", 51.516417, -0.179135 },
	{ 331, 0, "Bunhill Row, Moorgate", "", 51.520859, -0.089888 },
	{ 332, 0, "Nevern Place, Earl'S Court", "", 51.493343, -0.194758 },
	{ 333, 0, "Palace Gardens Terrace, Notting Hill", "", 51.508605, -0.193764 },
	{ 334, 0, "Concert Hall Approach 1, South Bank", "", 51.505044, -0.115851 },
	{ 335, 0, "Tavistock Street, Covent Garden", "", 51.511968, -0.120719 },
	{ 336, 0, "Concert Hall Approach 2, South Bank", "", 51.504942, -0.115533 },
	{ 337, 0, "Pembridge Road, Notting Hill", "", 51.511085, -0.197525 },
	{ 338, 0, "Wellington Street , Strand", "", 51.511756, -0.119643 },
	{ 339, 0, "Risinghill Street, Angel", "", 51.533320, -0.111781 },
	{ 340, 0, "Bank Of England Museum, Bank", "", 51.514441, -0.087587 },
	{ 341, 0, "Craven Street, Strand", "", 51.508103, -0.126021 },
	{ 343, 0, "Gloucester Slips Car Park, Regent'S Park", "", 51.536922, -0.150181 },
	{ 344, 0, "Goswell Road (City Uni), Finsbury", "", 51.528246, -0.101026 },
	{ 345, 0, "Flood Street, Chelsea", "", 51.488024, -0.166879 },
	{0, 0, NULL, NULL, 0., 0.}
};


struct StationsPluginSimplePrivateLondon : StationsPluginSimplePrivate {
  StationsPluginSimplePrivateLondon() {
    rect = QRectF(QPointF(51.300152, -0.326236), QPointF(51.700152, 0.073764));
    center = QPointF(51.500152, -0.126236);
    statusUrl = "";
    infosUrl = "https://web.barclayscyclehire.tfl.gov.uk/maps";
  }

  QList < Station * > fetchAll(StationsPlugin *plugin) {
    QList < Station * > list;

    for (int i = 0; stations[i].name; ++i) {
      Station *station = new Station(plugin);

      station->setId(stations[i].number);
      station->setName(QString::fromUtf8(stations[i].name));
      station->setDescription(QString::fromUtf8(stations[i].address));
      station->setPos(QPointF(stations[i].x, stations[i].y));
      station->setRegion(QString("London %1").arg(stations[i].arrondissementNumber));
      list.append(station);
    }

    return list;
  }

  QStringList regions() {
    QStringList ret;


    return ret;
  }
};

#endif /* STATIONS_SIMPLE_PRIVATE_LONDON_H */

