#!/usr/bin/python

#Stuff to import
import sys
from PyQt4 import QtCore, QtGui
from PyQt4.QtGui import *
from PyQt4.QtCore import *

#import Image
#import code

CURRENTVERSION = "0.5-1"

class MainWindow(QtGui.QMainWindow):
    def __init__(self):
                
        #create window
        QtGui.QMainWindow.__init__(self)
        self.fullScreen = False

        #Initial Settings
        self.resize(800,480)
        self.setWindowTitle("London Tube Map " + CURRENTVERSION)
        
        #Open Image
        self.LoadImage()
        
        #BUTTONS#
        
        #Fullscreen Button        
        fs = QtGui.QPushButton('', self)
        fs.setGeometry(750, 0, 60, 48)
        self.connect(fs, QtCore.SIGNAL('clicked()'), self.fullscreen)
        fsicon = QIcon("/opt/ltm/images/general_fullsize.png")
        fs.setIcon(fsicon)
        fs.setStyleSheet( "background-color: rgba( 255, 255, 255, 0% );" )

        #Back to Start Button
        st = QtGui.QPushButton('', self)
        st.setGeometry(0, 200, 60, 48)
        sticon = QIcon("/opt/ltm/images/bck.png")
        st.setIcon(sticon)
        st.setStyleSheet( "background-color: rgba( 255, 255, 255, 0% );" )
        self.connect(st, QtCore.SIGNAL('clicked()'), self.zoomSt)


        #MENU BAR#

        #About
        abt = QtGui.QAction('About', self)
        abt.setShortcut('Qt.Key_F')
        self.connect(abt, QtCore.SIGNAL('triggered()'), self.showAbout)
        
        #Portrait
        port = QtGui.QAction('Portrait', self)
        self.connect(port, QtCore.SIGNAL('triggered()'), self.setPortrait)
        
        #Landscape
        lands = QtGui.QAction('Landscape', self)
        self.connect(lands, QtCore.SIGNAL('triggered()'), self.setLandscape)
        
        #Connect to Menu Bar
        menubar = self.menuBar()
        file = menubar.addMenu('&File')
        file.addAction(port)
        file.addAction(lands)
        file.addAction(abt)
        
        #About page
    def showAbout(self):
        aboutString = "London Tube Map: v" + CURRENTVERSION + "\nAmir B (benjezzy@gmail.com)\nMaemo Forums: El Amir, \nTwitter: @benjezzy \nMany thanks to everyone who helped! "
        QtGui.QMessageBox.information(self, "About LTM: London Tube Map", aboutString)
        
    def fullscreen(self):
        if not self.fullScreen :
            self.showFullScreen()
        else:
            self.showNormal()

        self.fullScreen = not (self.fullScreen)    
    
    def defaultScrollBars(self):
        self.area.verticalScrollBar().setValue(500)
        self.area.horizontalScrollBar().setValue(500)
        
    def zoomSt(self):
        print "Back to start"
        self.defaultScrollBars()
        
    def setPortrait(self):
        self.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)
        #self.defaultScrollBars()
            
    def setLandscape(self):
        self.setAttribute(Qt.WA_Maemo5PortraitOrientation, False)
        self.defaultScrollBars()


    def LoadImage(self):
        objImg = QtGui.QImage("/opt/ltm/images/map.png")


        #creation du cadre central
        self.cadre = QtGui.QLabel(self)
        self.cadre.setPixmap(QtGui.QPixmap.fromImage(objImg))
        self.area = QtGui.QScrollArea(self)
        self.area.setWidget(self.cadre)
        self.setCentralWidget(self.area)
        

        self.defaultScrollBars()


#creation d'un objet application
app=QtGui.QApplication(sys.argv)
#creation de la fenetre principale
main=MainWindow()
#affichage de la fenetre
main.show()
#closes the app
sys.exit(app.exec_())