#!/usr/bin/env python
#-*- coding: utf-8 -*-

import sys
import random
import urllib2
import subprocess
from PySide import QtCore
from PySide.QtCore import Qt
from PySide import QtGui
from PySide import QtDeclarative

class lotto():
	def __init__(self):
		self.view = QtDeclarative.QDeclarativeView()		

		# instantiate the Python object
		self.pyfunc = pyfunc()

    		# expose the object to QML
		self.context = self.view.rootContext()
		self.context.setContextProperty("pyfunc", self.pyfunc)
		
		self.view.setSource(QtCore.QUrl('lotto.qml'))
		self.view.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)
		self.root = self.view.rootObject()
		self.buttonGen = self.root.findChild(QtCore.QObject,"gen_button_mouse")
		self.buttonGen.clicked.connect(self.lotto_fun)
		
#--------------------------------------------------------------------------------------------------
		#Ziehdatum
		zd = self.ziehdatum()
		self.root.updateZiehdatum('Ziehung vom: %s' % zd)

		#Zahlen der letzten Ziehung
		zlz = self.last_ziehung(ziehung=[])
		zlz = zlz[:6]
		self.root.updateZiehung('%s' % " ".join(zlz))

		#Zusatzzahl
		zz = self.zusatzzahl()
		self.root.updateZZ('Zusatzzahl: %s' % zz)

		#Superzahl
		sz = self.superzahl()
		self.root.updateSZ('Superzahl: %s' % sz)

		#Spiel77
		s77 = self.last_spiel77(spiel77=[])
		s77 = s77[6:13]
		self.root.updateSpiel77('Spiel 77:  %s' % " ".join(s77))

		#Super6
		s6 = self.last_super6(super6=[])
		s6 = s6[13:]
		self.root.updateSuper6('Super 6:  %s' % " ".join(s6))



#--------------------------------------------------------------------------------------------------

	def lotto_fun(self):
		win = self.generate_numbers(1,50)
		self.root.updateTipp(win)

#--------------------------------------------------------------------------------------------------

	def generate_numbers(self, range_start, range_end):
		#"Mischung der Kugeln"
		numbers = range(range_start, range_end)
		random.shuffle(numbers)

		#Ziehung der Nummern
		winnum = numbers[:6]
		win = winnum.sort()
		winnum = '%s' % winnum
		win = winnum[1:-1]

		return win

#--------------------------------------------------------------------------------------------------

	#Zahlen der letzten Ziehung
	def last_ziehung(self, ziehung):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for lines in url.readlines():
				if lines.startswith('        <span>'):
					zahlen = lines[14:-8]
					ziehung.append(zahlen)
			return ziehung

		except:
			ziehung = ' '
			return ziehung

#--------------------------------------------------------------------------------------------------
	#Datum der letzten Ziehung
	def ziehdatum(self):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for ziehdatum in url.readlines():
				if ziehdatum.startswith('<h2>Zahlen der Ziehung vom'):
					ziehdatum = ziehdatum[27:-6]
					return ziehdatum

		except:
			ziehdatum = ' '
			return ziehdatum

#--------------------------------------------------------------------------------------------------

	#spiel77
	def last_spiel77(self, spiel77):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for lines in url.readlines():
				if lines.startswith('        <span>'):
					zahlen = lines[14:-8]
					spiel77.append(zahlen)
			return spiel77

		except:
			spiel77 = ' '
			return spiel77

#--------------------------------------------------------------------------------------------------

	#super6
	def last_super6(self, super6):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for lines in url.readlines():
				if lines.startswith('        <span>'):
					zahlen = lines[14:-8]
					super6.append(zahlen)
			return super6

		except:
			super6 = ' '
			return super6

#--------------------------------------------------------------------------------------------------

	#zusatzzahl
	def zusatzzahl(self):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for zz in url.readlines():
				if zz.startswith('    ZZ: <span>'):
					zz = zz[14:-20]
					return zz

		except:
			zz = ' '
			return zz

#--------------------------------------------------------------------------------------------------

	#superzahl
	def superzahl(self):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for sz in url.readlines():
				if sz.startswith('    SZ: <span>'):
					sz = sz[14:-8]
					return sz

		except:
			sz = ' '
			return sz

#--------------------------------------------------------------------------------------------------

# Klasse für Funktionen die aus QML heraus angesprochen werden sollen:
class pyfunc(QtCore.QObject):
	#Beenden Funktion
	@QtCore.Slot()
	def ende(self):
		exit()

	@QtCore.Slot()
	def minimize(self):
        #Thanks to Boris Pohlers PyQt Toolbox, cause I've found it there! :)
        	subprocess.Popen(['dbus-send', '--type=signal', '--session', '/com/nokia/hildon_desktop', 'com.nokia.hildon_desktop.exit_app_view'])

#--------------------------------------------------------------------------------------------------

if __name__ == '__main__':
	app = QtGui.QApplication(sys.argv)
	start = lotto()
	start.view.showFullScreen()
    	sys.exit(app.exec_())


