#ifndef PORTHOLESWINDOW_H
#define PORTHOLESWINDOW_H

#include <QMainWindow>
#include <QEventLoop>
#include "core/player.h"
#include "randomnumberpicker.h"

namespace Ui {
    class PortholesWindow;
}

class PortholesWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit PortholesWindow(QWidget *parent = 0, Player* player=0);
    ~PortholesWindow();

    void exec();

protected:
    void closeEvent(QCloseEvent *event);

private:
    Ui::PortholesWindow *ui;

    bool m_CanClose;
    int m_CurrentPlayer;
    int m_Random1;
    int m_Random2;
    RandomNumberPicker* m_RandomPicker1;
    RandomNumberPicker* m_RandomPicker2;
    Player* m_Player;
    QEventLoop* m_Loop;

    void UpdateData();
    void Play(int player);
    void Evaluate();

private slots:
    void RandomSlot(int);
    void PlaySlot();
};

#endif // PORTHOLESWINDOW_H
