#ifndef FIGHTWINDOW_H
#define FIGHTWINDOW_H

#include <QMainWindow>
#include "randomnumberpicker.h"
#include "core/player.h"
#include "core/book.h"
#include <QScriptEngine>

namespace Ui {
    class FightWindow;
}

class FightWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit FightWindow(QWidget *parent = 0, Player* player=0, Enemy* enemy=0, bool canEvade=false, QScriptEngine* engine=0);
    ~FightWindow();

    void exec();

protected:
    void closeEvent(QCloseEvent *event);

private:
    Ui::FightWindow *ui;

    RandomNumberPicker* m_RandomPicker;
    bool m_Close;
    int m_PlayerDamage;
    int m_PlayerPointsLost;
    int m_EnemyDamage;
    int m_EnemyPointsLost;
    int m_Round;
    int m_SurpriseRound;
    QScriptEngine* m_Engine;
    QEventLoop* m_Loop;
    bool m_CanEvade;
    bool m_Evaded;
    Player* m_Player;
    Enemy* m_Enemy;
    int m_AttackMultiplier;
    int m_AttackBonus;

    void UpdateData();
    void Evaluate(int number);

    QHash<int, QString> m_CombatResult;
    bool ExecuteScript(QString name, QString script);

private slots:
    void AttackSlot();
    void EvadeSlot();
    void RandomSlot(int);

public slots:
    void MessageBox(QString title, QString message);
    void Print(QString message);
    bool HasEvaded();
    void SetHasEvaded(bool value) { m_Evaded = value; }
    Enemy* GetEnemy();
    bool GetCanEvade();
    void SetCanEvade(bool);
    int GetRound();
    int GetLostEndurancePoints();
    int GetEnemyLostEndurancePoints() { return m_EnemyPointsLost; }
    void Close();
    void SetAttackBonus(int value) { m_AttackBonus = value; }
    void SetAttackMultiplier(int value) { m_AttackMultiplier = value; }
    void SetSurpriseRounds(int value) { m_SurpriseRound = value; }
    int GetRandomNumber();
    void EndFight();
    int GetPlayerDamage() { return m_PlayerDamage; }
    void SetPlayerDamage(int value) { m_PlayerDamage = value; }
    int GetEnemyDamage() { return m_EnemyDamage; }
    void SetEnemyDamage(int value) { m_EnemyDamage = value; }

};

#endif // FIGHTWINDOW_H
