#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "bookwindow.h"
#include "aboutwindow.h"
#include "playercreationwindow.h"
#include "bookswindow.h"
#include "settingswindow.h"
#include <QMessageBox>
#include <QtNetwork/QNetworkConfigurationManager>
#include "downloadwindow.h"
#include "commonstatic.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

#ifdef Q_OS_SYMBIAN
    ui->label->setPixmap(QPixmap(":/Images/lone-wolf_small.gif"));
#endif

    connect(ui->pbnLoad, SIGNAL(clicked()), this, SLOT(LoadSlot()));
    connect(ui->pbnNew, SIGNAL(clicked()), this, SLOT(NewSlot()));
    connect(ui->pbnBooks, SIGNAL(clicked()), this, SLOT(BooksSlot()));
    connect(ui->pbnSettings, SIGNAL(clicked()), this, SLOT(SettingsSlot()));
    connect(ui->pbnAbout, SIGNAL(clicked()), this, SLOT(AboutSlot()));
    connect(ui->pbnQuit, SIGNAL(clicked()), this, SLOT(QuitSlot()));

    QSettings settings;
    ui->pbnLoad->setVisible(QFile::exists(settings.fileName()));

    m_Books = new Books(this);
    m_Books->LoadList();
    ui->pbnNew->setEnabled(m_Books->BookExist(1));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::LoadSlot()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);

    ui->pbnLoad->setEnabled(false);
    ui->pbnNew->setEnabled(false);
    ui->pbnBooks->setEnabled(false);
    ui->pbnAbout->setEnabled(false);
    ui->pbnSettings->setEnabled(false);
    ui->pbnQuit->setEnabled(false);
    qApp->processEvents();
#endif

    BookWindow* w = new BookWindow(this);
    w->Init();

#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    setVisible(false);
    connect(w, SIGNAL(destroyed()), this, SLOT(BookwindowClosedSlot()));
    w->setParent(NULL);
#endif
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);

    ui->pbnLoad->setEnabled(true);
    ui->pbnNew->setEnabled(true);
    ui->pbnBooks->setEnabled(true);
    ui->pbnAbout->setEnabled(true);
    ui->pbnSettings->setEnabled(true);
    ui->pbnQuit->setEnabled(true);
#endif
    w->show();
}

void MainWindow::AboutSlot()
{
    AboutWindow* frm = new AboutWindow(this);
    frm->show();
    frm->Init();
    frm->exec();

    delete frm;
}

void MainWindow::NewSlot()
{
    QSettings settings;
    if (QFile::exists(settings.fileName())){
        QMessageBox msgBox(this);
        msgBox.setIcon(QMessageBox::Question);
        msgBox.setWindowTitle("Confirm");
        msgBox.setText("This will delete your current progress.\nYou will restart from book one.\n\nContinue?");
        msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        if (msgBox.exec() != QMessageBox::Yes)
            return;

        QFile::remove(settings.fileName());
    }

    PlayerCreationWindow* dlg = new PlayerCreationWindow(this);
    dlg->exec();
    Player* p = dlg->GetPlayer();
    delete dlg;
    if (p != NULL){        
        BookWindow* w = new BookWindow(this);
        connect(w, SIGNAL(destroyed()), this, SLOT(BookwindowClosedSlot()));
        w->Save("", p, 1, 0);
        w->Init();
        w->show();
    }else{
        BookwindowClosedSlot();
    }
}

void MainWindow::BookwindowClosedSlot()
{
    setVisible(true);
    QSettings settings;
    ui->pbnLoad->setVisible(QFile::exists(settings.fileName()));

    m_Books->LoadList();
    ui->pbnNew->setEnabled(m_Books->BookExist(1));
}

void MainWindow::BooksSlot()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);

    ui->pbnLoad->setEnabled(false);
    ui->pbnNew->setEnabled(false);
    ui->pbnBooks->setEnabled(false);
    ui->pbnAbout->setEnabled(false);
    ui->pbnSettings->setEnabled(false);
    ui->pbnQuit->setEnabled(false);
    qApp->processEvents();
#endif

    BooksWindow* w = new BooksWindow(this);

#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    setVisible(false);
    connect(w, SIGNAL(destroyed()), this, SLOT(BookwindowClosedSlot()));
    w->setParent(NULL);
#endif
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);

    ui->pbnLoad->setEnabled(true);
    ui->pbnNew->setEnabled(true);
    ui->pbnBooks->setEnabled(true);
    ui->pbnAbout->setEnabled(true);
    ui->pbnSettings->setEnabled(true);
    ui->pbnQuit->setEnabled(true);
#endif
    w->show();
}

void MainWindow::SettingsSlot(){
    SettingsWindow* dlg = new SettingsWindow(this);
    dlg->exec();
    delete dlg;
}

void MainWindow::QuitSlot()
{
    QApplication::quit();
}

void MainWindow::closeEvent(QCloseEvent*)
{
    QuitSlot();
}

bool MainWindow::IsConnected()
{
    QNetworkConfigurationManager mgr;
    return mgr.isOnline();
}

void MainWindow::CheckUpdate()
{
    DownloadWindow* dlg = new DownloadWindow(this, NULL, m_Books->DownloadUrl, QString("%1/books.xml").arg(Books::Directory()));
    if (dlg->exec() == QDialog::Accepted){
        m_Books->LoadList();

        bool update = false;
        foreach(BookEntry* b, m_Books->List){
            if (b->Available){
                if (QFile::exists(Books::GetBookFilename(b->Number))){
                    Book* book = new Book(this);
                    book->Load(Books::GetBookFilename(b->Number), false);
                    if (book->Version < b->Version || (book->Version == b->Version && book->Revision < b->Revision))
                        update = true;
                    delete book;

                    if (update)
                        break;
                }
            }
        }

        if (update){
            QMessageBox msgBox(this);
            msgBox.setIcon(QMessageBox::Question);
            msgBox.setWindowTitle("Updates available");
            msgBox.setText("Updates available.\nDo you want to download the books now?");
            msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
            if (msgBox.exec() == QMessageBox::Yes){
                BooksSlot();
            }
        }
    }
}

void MainWindow::showMaximized()
{
    QMainWindow::showMaximized();
    QSettings* settings = CommonStatic::GeneralSettings(this);
    if (settings->value("checkupdates", true).toBool()){
        if (IsConnected())
            CheckUpdate();
    }
    delete settings;
}

void MainWindow::show()
{
    QMainWindow::show();
    QSettings* settings = CommonStatic::GeneralSettings(this);
    if (settings->value("checkupdates", true).toBool()){
        if (IsConnected())
            CheckUpdate();
    }
    delete settings;
}
