#include "kaidiscipline.h"
#include <QStringList>

KaiDiscipline::KaiDiscipline(QObject *parent) :
    QObject(parent)
{
    Name = "";
    CombatSkillDelta = 0;
}

KaiDiscipline::KaiDiscipline(const KaiDiscipline& discipline) :
    QObject(discipline.parent())
{
    Name = discipline.Name;
    CombatSkillDelta = discipline.CombatSkillDelta;
}

QString KaiDiscipline::Description()
{
    return Name;
}

QString KaiDiscipline::ToString()
{
    return QString("%1|%2").arg(Name).arg(CombatSkillDelta);
}

void KaiDiscipline::FromString(QString string)
{
    QStringList e = string.split("|");
    if (e.count() >= 2){
        Name = e.at(0);
        CombatSkillDelta = e.at(1).toInt();
    }
}

Camouflage::Camouflage(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Camouflage";
    CombatSkillDelta = 0;
}

Hunting::Hunting(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Hunting";
    CombatSkillDelta = 0;
}

SixthSense::SixthSense(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Sixth Sense";
    CombatSkillDelta = 0;
}

Tracking::Tracking(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Tracking";
    CombatSkillDelta = 0;
}

Healing::Healing(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Healing";
    CombatSkillDelta = 0;
}

Weaponskill::Weaponskill(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Weaponskill";
    CombatSkillDelta = 0;
    Weapon = Weapon::None;
}

Weaponskill::Weaponskill(const Weaponskill& discipline)
    : KaiDiscipline(discipline)
{
    Weapon = discipline.Weapon;
}

QString Weaponskill::Description()
{
    return QString("%1 in %2").arg(Name).arg(Weapon::ClassDescription(Weapon));
}

QString Weaponskill::ToString()
{
    return QString("%1|%2|%3").arg(Name).arg(CombatSkillDelta).arg(Weapon);
}

void Weaponskill::FromString(QString string)
{
    QStringList e = string.split("|");
    if (e.count() >= 3){
        Name = e.at(0);
        CombatSkillDelta = e.at(1).toInt();
        Weapon = e.at(2).toInt();
    }
}

Mindshield::Mindshield(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Mindshield";
    CombatSkillDelta = 0;
}

Mindblast::Mindblast(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Mindblast";
    CombatSkillDelta = 2;
}

AnimalKinship::AnimalKinship(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Animal Kinship";
    CombatSkillDelta = 0;
}

MindOverMatter::MindOverMatter(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Mind Over Matter";
    CombatSkillDelta = 0;
}
