#ifndef KAIDISCIPLINE_H
#define KAIDISCIPLINE_H

#include <QObject>
#include "item.h"

class KaiDiscipline : public QObject
{
    Q_OBJECT
public:
    explicit KaiDiscipline(QObject *parent = 0);
    KaiDiscipline(const KaiDiscipline& discipline);

    QString Name;
    int CombatSkillDelta;

    virtual QString Description();

    virtual QString ToString();
    virtual void FromString(QString string);
};

class Camouflage : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Camouflage(QObject *parent = 0);
};

class Hunting : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Hunting(QObject *parent = 0);
};

class SixthSense : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit SixthSense(QObject *parent = 0);
};

class Tracking : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Tracking(QObject *parent = 0);
};

class Healing : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Healing(QObject *parent = 0);
};

class Weaponskill : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Weaponskill(QObject *parent = 0);
    Weaponskill(const Weaponskill& discipline);

    int Weapon;

    void FromString(QString string);
    QString ToString();
    QString Description();
};

class Mindshield : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Mindshield(QObject *parent = 0);
};

class Mindblast : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Mindblast(QObject *parent = 0);
};

class AnimalKinship : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit AnimalKinship(QObject *parent = 0);
};

class MindOverMatter : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit MindOverMatter(QObject *parent = 0);
};

#endif // KAIDISCIPLINE_H
