#include "item.h"
#include <QStringList>

PropertiesItem::PropertiesItem(QObject *parent) :
    QObject(parent)
{

}

PropertiesItem::PropertiesItem(const PropertiesItem& item) :
    QObject(item.parent())
{
    foreach(QString key, item.Properties.keys())
        Properties[key] = item.Properties[key];
}

QString PropertiesItem::GetProperty(QString name)
{
    if (Properties.contains(name))
        return Properties[name];
    return "";
}

void PropertiesItem::SetProperty(QString name, QString value)
{
    Properties[name] = value;
}



Item::Item(QObject *parent) :
    PropertiesItem(parent)
{
    Name = "";
    Description = "";
    SetQuantity(1);
    SetSize(1);
}

Item::Item(const Item& item) :
    PropertiesItem(item)
{
    Name = item.Name;
    Description = item.Description;
}

void Item::Use(QScriptEngine* engine, QScriptValue* functions)
{
    QScriptValue objectValue = engine->newQObject(this);
    engine->globalObject().setProperty("Item", objectValue);

    QScriptValue f = functions->property(QString("use_%1").arg(Name.replace("'", "").replace(" ", "")));
    if (f.isValid()){
        f.call();
    }
}

bool Item::GetCanBeEquipped()
{
    if (!HasProperty("CanBeEquipped"))
        return true;
    return GetBoolProperty("CanBeEquipped");
}

void Item::SetCanBeEquipped(bool value)
{
    if (!value && GetIsEquipped())
        Unequip();
    SetBoolProperty("CanBeEquipped", value);
}

Weapon::Weapon(QObject *parent) :
    Item(parent)
{
    SetIsWeapon(true);
    SetCanBeEquipped(true);
    SetHands(1);
}

Weapon::Weapon(const Weapon& weapon) :
        Item(weapon)
{
}

int Weapon::GetClass(QString wclass)
{
    if (!QString::compare(wclass, "Dagger", Qt::CaseInsensitive))
        return Weapon::Dagger;
    else if (!QString::compare(wclass, "Spear", Qt::CaseInsensitive))
        return Weapon::Spear;
    else if (!QString::compare(wclass, "Mace", Qt::CaseInsensitive))
        return Weapon::Mace;
    else if (!QString::compare(wclass, "ShortSword", Qt::CaseInsensitive))
        return Weapon::ShortSword;
    else if (!QString::compare(wclass, "Warhammer", Qt::CaseInsensitive))
        return Weapon::WarHammer;
    else if (!QString::compare(wclass, "Axe", Qt::CaseInsensitive))
        return Weapon::Axe;
    else if (!QString::compare(wclass, "Sword", Qt::CaseInsensitive))
        return Weapon::Sword;
    else if (!QString::compare(wclass, "Quarterstaff", Qt::CaseInsensitive))
        return Weapon::Quarterstaff;
    else if (!QString::compare(wclass, "Broadsword", Qt::CaseInsensitive))
        return Weapon::Broadsword;
    return Weapon::None;
}

void Weapon::AddClass(int iClass)
{
    QString str = GetProperty("Classes");
    str.append(QString(";%1").arg(iClass));
    SetProperty("Classes", str);
}

QList<int> Weapon::Classes()
{
    QList<int> res;
    QStringList str = GetProperty("Classes").split(";", QString::SkipEmptyParts);
    foreach (QString s, str){
        res.append(s.toInt());
    }
    return res;
}

QString Weapon::ClassDescription(int Class)
{
    switch (Class)
    {
    case Dagger:
        return "Dagger";
        break;
    case Spear:
        return "Spear";
        break;
    case Mace:
        return "Mace";
        break;
    case ShortSword:
        return "Short Sword";
        break;
    case WarHammer:
        return "Warhammer";
        break;
    case Axe:
        return "Axe";
        break;
    case Sword:
        return "Sword";
        break;
    case Quarterstaff:
        return "Quarterstaff";
        break;
    case Broadsword:
        return "Broadsword";
        break;
    default:
        return "";
        break;
    }
}

ShopItem::ShopItem(QObject *parent) :
    Weapon(parent)
{
    Price = 0;
    SellPrice = 0;
    UnlimitedQuantity = false;
}

Armor::Armor(QObject *parent) :
    Item(parent)
{
    SetIsArmor(true);
    SetCanBeEquipped(true);
}

Armor::Armor(const Armor& armor) :
        Item(armor)
{
}

int Armor::GetPlace(QString place)
{
    if (!QString::compare(place, "Head", Qt::CaseInsensitive))
        return Armor::Head;
    else if (!QString::compare(place, "Body", Qt::CaseInsensitive))
        return Armor::Body;
    else if (!QString::compare(place, "Hand", Qt::CaseInsensitive))
        return Armor::Hand;
    return Armor::None;
}

void Armor::SetPlace(int iPlace)
{
    SetArmorPlace(iPlace);
}

int Armor::Place()
{
    return GetArmorPlace();
}
