#ifndef BONUSDISCIPLINEWINDOW_H
#define BONUSDISCIPLINEWINDOW_H

#include <QDialog>
#include "core/player.h"
#include "randomnumberpicker.h"

namespace Ui {
    class BonusDisciplineWindow;
}

class BonusDisciplineWindow : public QDialog
{
    Q_OBJECT

public:
    explicit BonusDisciplineWindow(QWidget *parent = 0, Book* book=0, Player* player=0);
    ~BonusDisciplineWindow();

private:
    Ui::BonusDisciplineWindow *ui;

    Book* m_Book;
    RandomNumberPicker* m_RandomPicker;
    int m_Serie;
    Player* m_Player;
    QList<KaiDiscipline*> m_List;
    QList<QPushButton*> m_Buttons;

    QString m_RandomSender;

    void ShowData();
    KaiDiscipline* GetDiscipline(QString name);

private slots:
    void ChooseSlot();
    void RandomSlot();
    void GetRandomSlot(int);
    void DiscipleLinkSlot(QString link);
};

#endif // BONUSDISCIPLINEWINDOW_H
