#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "core/books.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void showMaximized();
    void show();

private:
    Ui::MainWindow *ui;

    Books* m_Books;
    bool IsConnected();
    void CheckUpdate();

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void LoadSlot();
    void NewSlot();
    void BooksSlot();
    void AboutSlot();
    void BookwindowClosedSlot();
    void SettingsSlot();
    void QuitSlot();
};

#endif // MAINWINDOW_H
