#include "statuswindow.h"
#include "ui_statuswindow.h"

#include <QPushButton>
#include "commonstatic.h"
#include "ruleswindow.h"
#include "combatskillwindow.h"
#include "noteswindow.h"
#include "controls/qdisabledcheckbox.h"

StatusWindow::StatusWindow(QWidget *parent, Player* player, Section* section, QScriptEngine* engine, QScriptValue* functions) :
    DialogWindow(parent),
    ui(new Ui::StatusWindow)
{
    ui->setupUi(this);
    SetCanClose(true);
#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    setAttribute(Qt::WA_Maemo5StackedWindow);

    QPalette secondaryPalette = CommonStatic::GetSecondaryPalette();
    ui->lblSectionItems->setPalette(secondaryPalette);
    ui->lblStatus->setPalette(secondaryPalette);
    ui->lblDisciplines->setPalette(secondaryPalette);
    ui->lblWeaponChecklist->setPalette(secondaryPalette);
    ui->lblRank->setPalette(secondaryPalette);
    ui->lblWeapons->setPalette(secondaryPalette);
    ui->lblItems->setPalette(secondaryPalette);
    ui->lblSpecialItems->setPalette(secondaryPalette);
    ui->lblEquippedWeapons->setPalette(secondaryPalette);
    ui->lblEquippedArmor->setPalette(secondaryPalette);
    ui->lblNotesD->setPalette(secondaryPalette);

    ui->pbnEditNotes->setMaximumSize(120, 50);
#endif
    ui->statusLayout->setAlignment(ui->chkQuiver, Qt::AlignRight);
    ui->lblCombatSkillD->setText("<a href=\"#\">Combat Skill:</a>");
    connect(ui->lblCombatSkillD, SIGNAL(linkActivated(QString)), this, SLOT(CombatSkillLinkSlot(QString)));

    connect(ui->pbnDropWeapon1, SIGNAL(clicked()), this, SLOT(DropWeapon1Slot()));
    connect(ui->pbnDropWeapon2, SIGNAL(clicked()), this, SLOT(DropWeapon2Slot()));
    connect(ui->pbnEquip1, SIGNAL(clicked()), this, SLOT(EquipWeapon1Slot()));
    connect(ui->pbnEquip2, SIGNAL(clicked()), this, SLOT(EquipWeapon2Slot()));
    connect(ui->pbnPickGoldCrowns, SIGNAL(clicked()), this, SLOT(TakeGoldCrownsSlot()));
    connect(ui->pbnEditNotes, SIGNAL(clicked()), this, SLOT(EditNotesSlot()));

    m_Engine = engine;
    m_Functions = functions;
    m_Section = section;
    m_Book = (Book*)m_Section->parent();
    m_Serie = m_Book->GetSerie();
    m_Player = player;
    ShowData();
}

StatusWindow::~StatusWindow()
{
    delete ui;
}

void StatusWindow::ShowData()
{
    QList<Item*>::const_iterator iterator;
    ui->lblNotes->setText(m_Player->GetNotes());

    switch (m_Serie){
    case Book::Kai:
        ui->lblDisciplines->setText("Kai Disciplines:");
        ui->lblQuiver->setVisible(false);
        ui->chkQuiver->setVisible(false);
        ui->lblArrowsD->setVisible(false);
        ui->lblArrows->setVisible(false);
        ui->lblWeaponChecklist->setVisible(false);
        break;
    case Book::Magnakai:
        ui->lblDisciplines->setText("Magnakai Disciplines:");
        ui->lblQuiver->setVisible(true);
        ui->chkQuiver->setVisible(true);
        ui->lblArrowsD->setVisible(true);
        ui->lblArrows->setVisible(true);
        ui->lblWeaponChecklist->setVisible(m_Player->HasDiscipline("Weaponmastery"));
        break;
    case Book::GrandMaster:
        ui->lblDisciplines->setText("Grand Master Disciplines:");
        break;
    case Book::NewOrder:
        ui->lblDisciplines->setText("New Order Disciplines:");
        break;
    }

    if (!m_Section || !m_Section->HasPickableItems()){
        ui->lblSectionItems->setVisible(false);
        ui->lineSection->setVisible(false);

        CommonStatic::ClearLayout(ui->laySectionCrowns);
        CommonStatic::ClearLayout(ui->laySectionItems);
    }else{
        ui->lblSectionItems->setVisible(true);

        CommonStatic::ClearLayout(ui->laySectionItems);
        if (m_Section->GoldCrowns > 0){
            ui->lblSecGoldCrowns->setText(QString::number(m_Section->GoldCrowns));
            if (m_Player->GoldCrowns == 50)
                ui->pbnPickGoldCrowns->setEnabled(false);
        }else{
            CommonStatic::ClearLayout(ui->laySectionCrowns);
        }

        int row = 1;
        for (iterator = m_Section->Items.constBegin(); iterator != m_Section->Items.constEnd(); ++iterator){
            Item* i = *iterator;
            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->laySectionItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->GetDescription());
            lbl->setWordWrap(true);
            ui->laySectionItems->addWidget(lbl, row, 1);

            QPushButton* pbn = new QPushButton(this);
            pbn->setObjectName(QString::number(row - 1));
            pbn->setText("Take");
            pbn->setMaximumSize(75, 50);
            connect(pbn, SIGNAL(clicked()), this, SLOT(TakeItemSlot()));
            ui->laySectionItems->addWidget(pbn, row, 2);
            row++;
        }
    }

    ui->lblSkill->setText(QString("%1/%2").arg(m_Player->GetCombatSkill()).arg(m_Player->GetBaseCombatSkill()));
    ui->lblEndurance->setText(QString("%1/%2").arg(m_Player->Endurance).arg(m_Player->GetBaseEndurance()));
    ui->lblCrowns->setText(QString("%1/50").arg(m_Player->GoldCrowns));
    ui->lblMeals->setText(QString::number(m_Player->MealsCount()));
    ui->chkQuiver->setChecked(m_Player->HasQuiver());
    ui->chkQuiver->setEnabled(false);
    ui->lblArrows->setText(QString("%1/%2")
                           .arg(m_Player->GetArrows())
                           .arg(m_Player->GetMaxArrows()));

    QList<Weapon*> weapons = m_Player->Weapons();
    ui->pbnDropWeapon1->setEnabled(false);
    ui->pbnEquip1->setEnabled(false);
    ui->pbnDropWeapon2->setEnabled(false);
    ui->pbnEquip2->setEnabled(false);
    if (weapons.count() > 0){
        ui->lblWeapon1->setText(weapons.at(0)->Name);
        ui->pbnDropWeapon1->setEnabled(true);
        ui->pbnEquip1->setEnabled(weapons.at(0)->GetCanBeEquipped() && !weapons.at(0)->Classes().contains(Weapon::Bow));
        if (weapons.at(0)->GetIsEquipped()){
            ui->pbnEquip1->setText("Unequip");
#ifdef Q_WS_MAEMO_5
            ui->pbnEquip1->setFixedWidth(120);
#endif
        }else{
            ui->pbnEquip1->setText("Equip");
#ifdef Q_WS_MAEMO_5
            ui->pbnEquip1->setFixedWidth(75);
#endif
        }
    }else{
        ui->lblWeapon1->setText("-");
    }

    if (weapons.count() > 1){
        ui->lblWeapon2->setText(weapons.at(1)->Name);
        ui->pbnDropWeapon2->setEnabled(true);
        ui->pbnEquip2->setEnabled(weapons.at(1)->GetCanBeEquipped() && !weapons.at(1)->Classes().contains(Weapon::Bow));
        if (weapons.at(1)->GetIsEquipped()){
            ui->pbnEquip2->setText("Unequip");
#ifdef Q_WS_MAEMO_5
            ui->pbnEquip2->setFixedWidth(120);
#endif
        }else{
            ui->pbnEquip2->setText("Equip");
#ifdef Q_WS_MAEMO_5
            ui->pbnEquip2->setFixedWidth(75);
#endif
        }
    }else{
        ui->lblWeapon2->setText("-");
    }

    CommonStatic::ClearLayout(ui->layEquippedWeapons);
    int row = 0;
    for (iterator = m_Player->Items.constBegin(); iterator != m_Player->Items.constEnd(); ++iterator){
        Item* w = *iterator;
        if (w->GetIsWeapon() && w->GetIsEquipped()){
            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);
            lbl->setText(w->Name);
            lbl->setWordWrap(true);
            ui->layEquippedWeapons->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
            lbl->setText(w->GetDescription());
            lbl->setWordWrap(true);
            ui->layEquippedWeapons->addWidget(lbl, row, 1);
            row++;
        }
    }
    if (!row){
        QLabel* lbl = new QLabel(this);
        lbl->setText("None (-4 Combat Skill)");
        lbl->setWordWrap(true);
        ui->layEquippedWeapons->addWidget(lbl, row, 0);
    }

    CommonStatic::ClearLayout(ui->layEquippedArmor);
    row = 0;
    for (iterator = m_Player->Items.constBegin(); iterator != m_Player->Items.constEnd(); ++iterator){
        Item* i = *iterator;
        if (i->GetIsArmor() && i->GetIsEquipped()){
            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->layEquippedArmor->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
            lbl->setText(i->GetDescription());
            lbl->setWordWrap(true);
            ui->layEquippedArmor->addWidget(lbl, row, 1);
            row++;
        }
    }
    if (!row){
        QLabel* lbl = new QLabel(this);
        lbl->setText("None");
        lbl->setWordWrap(true);
        ui->layEquippedArmor->addWidget(lbl, row, 0);
    }

    CommonStatic::ClearLayout(ui->layKaiDisciplines);
    CommonStatic::ClearLayout(ui->layWeaponChecklist);
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);
    QSizePolicy stretchOne;
    stretchOne.setHorizontalStretch(1);
    row = 0;
    QList<KaiDiscipline*>::const_iterator dIterator;
    for (dIterator = m_Player->KaiDisciplines.constBegin(); dIterator != m_Player->KaiDisciplines.constEnd(); ++dIterator){
        KaiDiscipline* d = *dIterator;
        if (d->Serie != m_Serie)
            continue;

        QLabel* lbl = new QLabel(this);
        lbl->setSizePolicy(stretchZero);
        lbl->setText(QString("<b>%1:</b>").arg(row + 1));
        ui->layKaiDisciplines->addWidget(lbl, row, 0);

        lbl = new QLabel(this);
        lbl->setText(QString("<a href=\"%1\">%2</a>").arg(d->Name.toLower().replace(" ", ""))
                                                     .arg(d->Description()));
        ui->layKaiDisciplines->addWidget(lbl, row, 1);
        connect(lbl, SIGNAL(linkActivated(QString)), this, SLOT(DiscipleLinkSlot(QString)));

        lbl = new QLabel(this);
        lbl->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
        lbl->setText(Player::GetRankDescription(m_Serie, row + 1));
        ui->layKaiDisciplines->addWidget(lbl, row, 2);
        row++;

        //Weaponmastery Checklist
        Weaponmastery* wm = qobject_cast<Weaponmastery*>(d);
        if (wm){
            QList<int> weapons = QList<int>() << Weapon::Dagger << Weapon::Mace << Weapon::WarHammer
                                              << Weapon::Axe << Weapon::Quarterstaff << Weapon::Spear
                                              << Weapon::ShortSword << Weapon::Bow << Weapon::Sword
                                              << Weapon::Broadsword;

            int wrow = 0;
            foreach (int w, weapons){
                lbl = new QLabel(this);
                lbl->setText(Weapon::ClassDescription(w));
                ui->layWeaponChecklist->addWidget(lbl, wrow, 0);

                QDisabledCheckBox* chk = new QDisabledCheckBox(this);
                chk->setChecked(wm->Weapons.contains(w));
                chk->setEnabled(false);
                ui->layWeaponChecklist->addWidget(chk, wrow, 1, Qt::AlignRight);

                wrow++;
            }
        }
    }

    CommonStatic::PopulateBackpackItemsLayout(this, m_Player, ui->layItems,
                                              SLOT(DropItemSlot()), "Drop",
                                              SLOT(UseItemSlot()), "");
    CommonStatic::PopulateSpecialItemsLayout(this, m_Player, ui->laySpecialItems,
                                             SLOT(DropItemSlot()), "Drop",
                                             SLOT(EquipItemSlot()));

}

bool StatusWindow::EquipArmor(Armor* armor)
{
    if (armor->GetIsEquipped()){
        armor->Unequip();
    }else{
        if (armor->GetClass() == Armor::Shield && !m_Player->GetCanUseShield()){
            QMessageBox msgBox(this);
            msgBox.setText("You cannot equip a shield now.");
            msgBox.exec();
            return false;
        }

        // Unequip the armor of the same class if present
        QList<Armor*> equipped = m_Player->GetEquippedArmors();
        foreach (Armor* a, equipped){
            if (a->GetArmorClass() == armor->GetClass())
                a->Unequip();
        }

        // Check free hands (only for shield
        if (armor->GetClass() == Armor::Shield){
            if (m_Player->GetFreeHands() >= 1){
                armor->Equip();
            }else{
                QMessageBox msgBox(this);
                msgBox.setText("You cannot equip a shield now.");
                msgBox.exec();
                return false;
            }
        }else
            armor->Equip();
    }
    m_Player->CheckEndurance();
    return true;
}

bool StatusWindow::EquipWeapon(Weapon* weapon)
{
    if (weapon->GetIsEquipped()){
        weapon->Unequip();        
    }else{
        Weapon* equipped = m_Player->GetEquippedWeapon();
        if (equipped != NULL)
            equipped->Unequip();
        if (m_Player->GetFreeHands() >= weapon->GetHands())
            weapon->Equip();
        else{
            QMessageBox msgBox(this);
            msgBox.setText("You cannot equip this weapon now.");
            msgBox.exec();
            return false;
        }
    }
    m_Player->CheckEndurance();
    return true;
}

void StatusWindow::EquipWeapon1Slot()
{
    Weapon* w = m_Player->Weapons().at(0);
    if (EquipWeapon(w))
        ShowData();
}

void StatusWindow::EquipWeapon2Slot()
{
    Weapon* w = m_Player->Weapons().at(1);
    if (EquipWeapon(w))
        ShowData();
}

void StatusWindow::DropWeapon1Slot()
{
    Weapon* w = m_Player->Weapons().at(0);
    if (DropWeapon(w))
        ShowData();
}

void StatusWindow::DropWeapon2Slot()
{
    Weapon* w = m_Player->Weapons().at(1);
    if (DropWeapon(w))
        ShowData();
}

bool StatusWindow::DropWeapon(Weapon* weapon)
{
    if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Drop the %1?").arg(weapon->Name)) == QMessageBox::Yes){
        weapon->Unequip();
        m_Player->CheckEndurance();
        m_Player->Items.removeOne(weapon);
        if (m_Section)
            m_Section->Items.append(weapon);
        else
            delete weapon;
        return true;
    }
    return false;
}

void StatusWindow::EquipItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Player->Items.at(idx);
    if (i->GetIsEquipped()){
        i->Unequip();
        m_Player->CheckEndurance();
        ShowData();
    }else{
        if (i->GetIsWeapon()){
            Weapon* w = (Weapon*)i;
            if (EquipWeapon(w))
                ShowData();
        }else if (i->GetIsArmor()){
            Armor* a = (Armor*)i;
            if (EquipArmor(a))
                ShowData();
        }
    }
}

void StatusWindow::DropItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Player->Items.at(idx);
    if (DropItem(i)){
        if (m_Player->Endurance > m_Player->GetBaseEndurance())
            m_Player->Endurance = m_Player->GetBaseEndurance();
        ShowData();
    }
}

bool StatusWindow::DropItem(Item* item)
{
    if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Drop the %1?").arg(item->Name)) == QMessageBox::Yes){
        item->Unequip();
        m_Player->CheckEndurance();
        m_Player->Items.removeOne(item);
        if (m_Section)
            m_Section->Items.append(item);
        else
            delete item;
        return true;
    }
    return false;
}

void StatusWindow::TakeItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Section->Items.at(idx);

    QString error;
    if (!m_Player->CanTakeItem(i, &error)){
        QMessageBox msgBox(this);
        msgBox.setText(error);
        msgBox.exec();
        return;
    }

    Weapon* w = qobject_cast<Weapon*>(i);
    if (w && !w->GetIsSpecial()){
        //Take weapon:
        m_Player->Items.append(w);
        m_Section->Items.removeOne(w);
        ShowData();
        return;
    }

    if (i->GetIsSpecial()){
        //Take special item:
        m_Player->Items.append(i);
        m_Section->Items.removeOne(i);
        ShowData();
        return;
    }else{
        //Take arrows:
        if (i->GetIsArrow()){
            m_Player->SetArrows(m_Player->GetArrows() + i->GetQuantity());
            m_Section->Items.removeOne(i);
            ShowData();
        }else{
            //Take normal item:
            if (!m_Player->HasBackpack() && i->GetIsBackpack()){
                m_Player->SetHasBackpack(true);
                m_Section->Items.removeOne(i);
                ShowData();
                return;
            }else{
                m_Player->Items.append(i);
                m_Section->Items.removeOne(i);
                ShowData();
                return;
            }
        }
    }
}

void StatusWindow::TakeGoldCrownsSlot()
{
    int toTake = m_Section->GoldCrowns;
    if (m_Player->GoldCrowns + m_Section->GoldCrowns > 50)
        toTake = 50 - m_Player->GoldCrowns;
    m_Player->GoldCrowns += toTake;
    m_Section->GoldCrowns -= toTake;

    ShowData();
}

void StatusWindow::UseItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Player->Items.at(idx);

    QMessageBox::StandardButton res = QMessageBox::No;

    if (i->GetIsMeal())
        res = CommonStatic::ConfirmMessage(this, "Confirm", QString("Eat the %1?").arg(i->Name));
    else
        res = CommonStatic::ConfirmMessage(this, "Confirm", QString("Use the %1?").arg(i->Name));

    if (res == QMessageBox::Yes){
        i->Use(m_Engine, m_Functions);
        m_UsedItems.append(i);
        if (i->GetUsability() <= 0)
            m_Player->Items.removeOne(i);
        ShowData();
    }
}

void StatusWindow::DiscipleLinkSlot(QString link)
{
    RulesWindow* dlg = new RulesWindow(this, m_Book->BaseDirectory);
    dlg->show();
    dlg->ScrollToAnchor(link);
    dlg->exec();
}

void StatusWindow::CombatSkillLinkSlot(QString)
{
    CombatSkillWindow* dlg = new CombatSkillWindow(this, m_Player, NULL);
    dlg->exec();
}

void StatusWindow::EditNotesSlot()
{
    NotesWindow* dlg = new NotesWindow(this, m_Player);
    connect(dlg, SIGNAL(destroyed()), this, SLOT(EditNotesClosedSlot()));
    dlg->show();
}

void StatusWindow::EditNotesClosedSlot()
{
    ui->lblNotes->setText(m_Player->GetNotes());
}
