#include "randomnumberpicker.h"
#include <QTime>
#include <QThread>
#include <QApplication>

class SleeperThread : public QThread
{
public:
    static void msleep(unsigned long msecs){
        QThread::msleep(msecs);
    }
};

RandomNumberPicker::RandomNumberPicker(QObject *parent, QLabel* label, bool centerOnParent, int min, int max, int bonus) :
    QObject(parent)
{
    m_CenterOnParent = centerOnParent;
    m_Bonus = bonus;
    m_Min = min;
    m_Max = max;
    m_Label = label;
    if (m_Label && centerOnParent)
        m_Label->setVisible(false);
    QTime midnight(0, 0, 0);
    qsrand(midnight.secsTo(QTime::currentTime()));
    m_DiceValue = 0;

    m_DiceTimer = new QTimer(this);
    m_DiceTimer->setInterval(100);
    m_DiceTimer->setSingleShot(false);
    connect(m_DiceTimer, SIGNAL(timeout()), this, SLOT(DiceTimerSlot()));
}

void RandomNumberPicker::DiceTimerSlot()
{
    m_DiceProgress++;

    int random = 0;
    if (m_DiceProgress <= 20){
        random = qrand() % 10;
        if (random == 10)
            random = 0;
        if (m_Label){
            if (!m_Bonus)
                m_Label->setText(QString::number(random));
            else{
                if (m_Bonus > 0)
                    m_Label->setText(QString("%1+%2").arg(random).arg(m_Bonus));
                else
                    m_Label->setText(QString("%1%2").arg(random).arg(m_Bonus));
            }
            m_Label->update();
        }
    }

    if (m_DiceProgress == 20){
        if (m_Label && m_CenterOnParent)
#ifdef Q_WS_MAEMO_5
            m_Label->setStyleSheet("QLabel { color: black; background-color: white }");
#else
            m_Label->setStyleSheet("QLabel { color: white; background-color: black }");
#endif
        m_DiceValue = random;
    } else if (m_DiceProgress == 25){
        m_DiceTimer->stop();
        if (m_CenterOnParent)
            m_Label->setVisible(false);
        m_Working = false;
        emit Random(m_DiceValue + m_Bonus);
    }
}

void RandomNumberPicker::GetRandomNumber(QWidget* labelParent, int* result)
{
    m_DiceValue = 0;
    m_Working = true;
    if (m_Label){
        if (m_CenterOnParent){
            m_Label->setParent(labelParent);
#ifdef Q_WS_MAEMO_5
            m_Label->setStyleSheet("QLabel { color: white; background-color: black }");
#else
            m_Label->setStyleSheet("QLabel { color: black; background-color: white }");
#endif
            if (!m_Bonus)
                m_Label->setFixedSize(100, 100);
            else
                m_Label->setFixedSize(150, 100);
            m_Label->move(labelParent->width() / 2 - (m_Label->width() / 2),
                          labelParent->height() / 2 - (m_Label->height() / 2));
            m_Label->setVisible(true);
        }

        if (!m_Bonus)
            m_Label->setText("0");
        else{
            if (m_Bonus > 0)
                m_Label->setText(QString("0+%2").arg(m_Bonus));
            else
                m_Label->setText(QString("0%2").arg(m_Bonus));
        }
    }

    m_DiceProgress = 0;
    m_DiceTimer->start();

    if (result != NULL){
        while(m_Working){
            qApp->processEvents();
            SleeperThread::msleep(50);
        }
        *result = m_DiceValue + m_Bonus;
    }
}
