#ifndef CHOOSEITEMWINDOW_H
#define CHOOSEITEMWINDOW_H

#include "controls/dialogwindow.h"
#include "core/player.h"

namespace Ui {
    class ChooseItemWindow;
}

class ChooseItemWindow : public DialogWindow
{
    Q_OBJECT

public:
    enum ChooseMode{
        ChooseMeal,
        ChooseItem,
        ChooseItemExceptMeals,
        ChooseSpecialItem,
        ChooseWeapon,
        ChooseWeaponSpecial
    };

    explicit ChooseItemWindow(QWidget *parent = 0, Player* player=0, int mode=ChooseMeal, bool mandatory=true);
    ~ChooseItemWindow();

    Item* SelectedItem() { return m_Selected; }    
    void SetMessage(QString message);

private:
    Ui::ChooseItemWindow *ui;

    int m_Mode;
    Player* m_Player;
    Item* m_Selected;

    void ShowItems();

    void ShowBackpackItems(bool excludeMeals=false);
    void ShowSpecialItems();
    void ShowMeals();
    void ShowWeapons(bool special=false);

private slots:
    void SelectedSlot();
    void CancelSlot();
};

#endif // CHOOSEITEMWINDOW_H
