#include "bookinfowindow.h"
#include "ui_bookinfowindow.h"
#include "commonstatic.h"

BookInfoWindow::BookInfoWindow(QWidget *parent, Book* book) :
    QDialog(parent),
    ui(new Ui::BookInfoWindow)
{
    ui->setupUi(this);

    m_Book = book;

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);

    QPalette secondaryPalette = CommonStatic::GetSecondaryPalette();
    ui->lblTitleD->setPalette(secondaryPalette);
    ui->lblAuthorsD->setPalette(secondaryPalette);
    ui->lblNumberD->setPalette(secondaryPalette);
    ui->lblVersionD->setPalette(secondaryPalette);
    ui->lblSectionsD->setPalette(secondaryPalette);
    ui->lblScriptedByD->setPalette(secondaryPalette);
#endif

    ui->lblTitle->setText(m_Book->Title);
    ui->lblAuthors->setText(m_Book->Authors);
    ui->lblNumber->setText(QString::number(m_Book->Number));
    ui->lblVersion->setText(QString("%1.%2").arg(m_Book->Version).arg(m_Book->Revision));
    ui->lblSections->setText(QString::number(m_Book->Sections.count() - 1));
    ui->lblScriptedBy->setText(m_Book->ScriptedBy);

#ifdef Q_WS_MAEMO_5
    ui->pbnOk->setVisible(false);
#else
    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(accept()));
#endif
}

BookInfoWindow::~BookInfoWindow()
{
    delete ui;
}
