#include "betwindow.h"
#include "ui_betwindow.h"
#include "commonstatic.h"

BetWindow::BetWindow(QWidget *parent, Player* player) :
    DialogWindow(parent),
    ui(new Ui::BetWindow)
{
    ui->setupUi(this);
#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    SetCanClose(true);
    m_Won = 0;
    m_Value = 0;
    m_Player = player;

    m_Round = 0;
    m_Bet = 1;
    ui->lblBet->setText(QString::number(m_Bet));

    m_RandomPicker = new RandomNumberPicker(this, ui->lblDice, false);
    connect(m_RandomPicker, SIGNAL(Random(int)), SLOT(RandomSlot(int)));

    connect(ui->pbnBetMinus, SIGNAL(clicked()), this, SLOT(BetMinusSlot()));
    connect(ui->pbnBetPlus, SIGNAL(clicked()), this, SLOT(BetPlusSlot()));
    connect(ui->pbnLeave, SIGNAL(clicked()), this, SLOT(close()));
    connect(ui->pbnPlay, SIGNAL(clicked()), this, SLOT(PlaySlot()));

    UpdateData();
}

BetWindow::~BetWindow()
{
    delete ui;
}

void BetWindow::RandomSlot(int random)
{
    if (m_Number == 0){
        ui->lblNumber1->setText(QString::number(random));
        m_Number++;
        m_RandomPicker->GetRandomNumber(NULL);
    }else{
        ui->lblNumber2->setText(QString::number(random + 3));
        Evaluate();
        UpdateData();
        EnableButtons(true);
    }
}

void BetWindow::UpdateData()
{
    ui->lblGoldCrowns->setText(QString::number(m_Player->GetGoldCrowns()));
}

void BetWindow::EnableButtons(bool enable)
{
    ui->pbnBetMinus->setEnabled(enable);
    ui->pbnBetPlus->setEnabled(enable);
    ui->pbnLeave->setEnabled(enable);

    if (m_Won == 40 || m_Player->GetGoldCrowns() == 0)
        ui->pbnPlay->setEnabled(false);
    else
        ui->pbnPlay->setEnabled(enable);
}

void BetWindow::Evaluate()
{
    int number1 = ui->lblNumber1->text().toInt();
    int number2 = ui->lblNumber2->text().toInt();

    int won = 0;
    int lost = 0;

    if (number1 > number2)
        won = m_Bet * 2;
    else
        lost = m_Bet;

    if (lost)
        ui->lblMessage->setText(QString("You lost %2 Gold Crown(s)").arg(lost));
    else
        ui->lblMessage->setText(QString("You won %2 Gold Crowns").arg(won));

    m_Player->SetGoldCrowns(m_Player->GetGoldCrowns() + won - lost);
    SetCanClose(true);
    if (m_Round == 3)
        ui->pbnPlay->setEnabled(false);
}

void BetWindow::BetMinusSlot()
{
    if (m_Bet > 1){
        m_Bet--;
        ui->lblBet->setText(QString::number(m_Bet));
    }
}

void BetWindow::BetPlusSlot()
{
    if (m_Bet < m_Player->GoldCrowns && m_Bet < 10){
        m_Bet++;
        ui->lblBet->setText(QString::number(m_Bet));
    }
}

void BetWindow::PlaySlot(){
    m_Round++;
    SetCanClose(false);
    EnableButtons(false);
    ui->lblMessage->clear();

    m_Number = 0;
    m_RandomPicker->GetRandomNumber(NULL);
}
