#ifndef COMMONSTATIC_H
#define COMMONSTATIC_H

#include <QObject>
#include <QMessageBox>
#include <QSettings>
#include <QMainWindow>
#include <QLayout>

class Player;

class CommonStatic
{
public:
    explicit CommonStatic();

    static void Message(QWidget* parent, QString title, QString message);
    static QMessageBox::StandardButton ConfirmMessage(QWidget* parent, QString title, QString message);

    static QSettings* GeneralSettings(QObject * parent=0);

    static void CenterWindow(QWidget* w);
    static void ClearLayout(QLayout* layout);

    static void PopulateBackpackItemsLayout(QWidget* parent, Player* player, QGridLayout* layout,
                                            const char* dropSlot, QString dropLabel,
                                            const char* useSlot, const char* sellSlot);
    static void PopulateSpecialItemsLayout(QWidget* parent, Player* player, QGridLayout* layout,
                                           const char* dropSlot, QString dropLabel,
                                           const char* equipSlot);

#ifdef Q_WS_MAEMO_5
    static QPalette GetSecondaryPalette();
#endif
};

#endif // COMMONSTATIC_H
