#ifndef CARTWHEELWINDOW_H
#define CARTWHEELWINDOW_H

#include <QMainWindow>
#include <QEventLoop>
#include "controls/dialogwindow.h"
#include "core/player.h"
#include "randomnumberpicker.h"

namespace Ui {
    class CartwheelWindow;
}

class CartwheelWindow : public DialogWindow
{
    Q_OBJECT

public:
    explicit CartwheelWindow(QWidget *parent = 0, Player* player=0);
    ~CartwheelWindow();

private:
    Ui::CartwheelWindow *ui;

    int m_Bet;
    int m_Value;
    int m_Won;
    Player* m_Player;

    RandomNumberPicker* m_RandomPicker;

    void EnableButtons(bool enable);
    void UpdateData();
    void Evaluate(int random);

private slots:
    void RandomSlot(int);
    void BetMinusSlot();
    void BetPlusSlot();
    void MinusSlot();
    void PlusSlot();
    void PlaySlot();

};

#endif // CARTWHEELWINDOW_H
