#ifndef BRTWINDOW_H
#define BETWINDOW_H

#include <QMainWindow>
#include <QEventLoop>
#include "controls/dialogwindow.h"
#include "core/player.h"
#include "randomnumberpicker.h"

namespace Ui {
    class BetWindow;
}

class BetWindow : public DialogWindow
{
    Q_OBJECT

public:
    explicit BetWindow(QWidget *parent = 0, Player* player=0);
    ~BetWindow();

    int GetRounds() { return m_Round; }

private:
    Ui::BetWindow *ui;

    int m_Bet;
    int m_Value;
    int m_Won;
    Player* m_Player;

    int m_Round;
    int m_Number;
    RandomNumberPicker* m_RandomPicker;

    void EnableButtons(bool enable);
    void UpdateData();
    void Evaluate();

private slots:
    void RandomSlot(int);
    void BetMinusSlot();
    void BetPlusSlot();
    void PlaySlot();

};

#endif // BETWINDOW_H
