#include "version.h"
#include <QStringList>

VersionClass::VersionClass()
{
}

QString VersionClass::ToString()
{
    return QString("%1.%2.%3")
            .arg(GetVersion())
            .arg(GetModify())
            .arg(GetRevision());
}

QString VersionClass::ToComparableString() const
{
    return QString("%1.%2.%3")
            .arg(GetVersion(), 4, 10, QChar('0'))
            .arg(GetModify(), 4, 10, QChar('0'))
            .arg(GetRevision(), 4, 10, QChar('0'));
}

void VersionClass::FromString(QString value)
{
    QStringList e = value.split(".", QString::SkipEmptyParts);

    SetVersion(0);
    SetModify(0);
    SetRevision(0);

    if (e.count() > 0)
        SetVersion(e.at(0).toInt());
    if (e.count() > 1)
        SetModify(e.at(1).toInt());
    if (e.count() > 2)
        SetRevision(e.at(2).toInt());
}

bool VersionClass::operator>(const VersionClass &versionClass)
{
    return ToComparableString() > versionClass.ToComparableString();
}

bool VersionClass::operator<(const VersionClass &versionClass)
{
    return ToComparableString() < versionClass.ToComparableString();
}

bool VersionClass::operator=(const VersionClass &versionClass)
{
    return ToComparableString() == versionClass.ToComparableString();
}

bool VersionClass::operator!=(const VersionClass &versionClass)
{
    return ToComparableString() != versionClass.ToComparableString();
}
