#ifndef BOOKWINDOW_H
#define BOOKWINDOW_H

#include <QMainWindow>
#include <QScriptEngine>
#include <QPushButton>
#include "core/book.h"
#include "core/player.h"
#include "randomnumberpicker.h"

namespace Ui {
    class BookWindow;
}

//!  The main window
/*!

*/
class BookWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit BookWindow(QWidget *parent = 0);
    ~BookWindow();

    void Save(QString filename, Player* player, int book, int section);
    bool Init();
    static QString GetBookSaveFilename(int number);

private:
    Ui::BookWindow *ui;

    QList<QPushButton*> m_ChoiceButtons;
    QFont m_Font;
    QSettings* m_Settings;
    RandomNumberPicker* m_RandomPicker;
    int m_DiceValue;
    QScriptEngine m_Engine;
    QScriptValue m_Functions;
    bool m_Fought;
    int m_Ate;
    Player* m_Player;
    Book* m_Book;
    Section* m_Section;
    bool m_Loaded;
    int m_PickGoldCrowns;
    QList<Item*> m_PickItems;

    void SetVisibleChoiceButtons(int number);
    void ShowSection(int section);
    void ShowSectionChoices(int section);
    void ExitSection();
    void UpdateToolbar();
    void EvaluateRandomChoice(int number);
    void LoadBookFunctions();
    bool ExecuteSystemScript(QString name);
    bool ExecuteScript(QString name, QString script);
    bool ExecuteChoiceScript(Choice* choice);
    void EndMission();    
    void SetChoicesText();
    void SetChoiceText(QPushButton*, QString);    
    bool Load(QString filename="");
    QString GetTempSaveFilename();

    void EndTempCombatSkillEffect();

protected:
    void resizeEvent(QResizeEvent *event);

private slots:
    void LoadFinishedSlot(bool);
    void ShowSectionSlot();
    void GoSlot();

    void ChoiceSlot();
    void FightSlot();
    void PickItemsSlot();
    void StatusSlot();
    void GetRandomSlot();
    void RandomSlot(int);
    void EndSlot();

    void RulesSlot();
    void AboutSlot();
    void MapSlot();
    void BookInfoSlot();
    void BookRestartSlot();
    void ShopSlot();
    void ScrollToTopSlot();

public slots:
    /** Print a message on the window */
    void Print(QString);
    /** Display a message box */
    void MessageBox(QString title, QString message);
    /** Returns the name of a meal choosen by the player */
    QString ChooseMeal(QString title);
    /** Returns the name of a weapon choosen by the player */
    QString ChooseWeapon(QString title);
    /** Returns the name of a backpack item choosen by the player */
    QString ChooseItem(QString title);
    /** Returns the name of a backpack item (except meals) choosen by the player */
    QString ChooseItemExceptMeals(QString title);
    /** Returns the name of a special item choosen by the player */
    QString ChooseSpecialItem(QString title);
    /** Ask the player to add a bonus discipline */
    void AddBonusDiscipline();
    /** Ask the player to add bonus disciplines */
    void AddBonusDisciplines(int number);
    /** Loads the next book */
    bool LoadNextBook();
    void show();

    /** Clears the pick items list */
    void ClearPickItems();
    /** Adds gold crowns to the pick item window.
    If goldCrowns is < 0 then the number will be picked using a random number */
    void AddPickGoldCrowns(int goldCrowns);
    /** Adds random number gold crowns to the pick item window with the given bonus. */
    void AddPickRandomGoldCrowns(int bonus);
    /** Adds a item (or special item) to the pick item window. */
    Item* AddPickItem(QString name, bool special);
    /** Adds a meal to the pick item window. */
    Item* AddMealPickItem(QString name);
    /** Adds a weapon to the pick item window. */
    Weapon* AddWeaponPickItem(QString name, QString className);
    /** Adds a healing item to the pick item window. */
    Item* AddHealingPickItem(QString name, int enduranceDelta);
    /** Let the player pick items from the pick item window. */
    int PickItems(int max);
    /** Returns a number of Gold Crowns selected by the player */
    int SelectGoldCrowns(int min);
    /** Returns a random number */
    int GetRandomNumber();
    /** Returns a random number using the given bonus */
    int GetRandomNumberWithBonus(int bonus);
    /** Disables the given choice button */
    void DisableChoiceButton(int);
    /** Enables the given choice button */
    void EnableChoiceButton(int);
    /** Disables all the choice buttons */
    void DisableChoiceButtons();
    /** Enables all the choice buttons (of enabled choices) */
    void EnableChoiceButtons();
    /** Executes the given choice */
    void DoChoice(int number);
    /** Disables the "Fight" button */
    void DisableFightButton();
    /** Enables the "Fight" button */
    void EnableFightButton();
    /** Returns a number selected by the player in the given range */
    int InputNumber(QString title, int min, int max);

    /** Play the "Cartwheel" game (book 2) */
    void PlayCartwheel();
    /** Play the "Portholes" game (book 2) */
    void PlayPortholes();
    /** Play the bet game (book 6) */
    int PlayBetGame();
};

#endif // BOOKWINDOW_H
