#include "pickitemswindow.h"
#include "ui_pickitemswindow.h"
#include "commonstatic.h"

PickItemsWindow::PickItemsWindow(QWidget *parent, Player* player, int serie, int goldCrowns, QList<Item*>* items, int max) :
    DialogWindow(parent),
    ui(new Ui::PickItemsWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    m_Serie = serie;
    m_Player = player;
    m_GoldCrowns = goldCrowns;
    m_SelectedGoldCrowns = 0;
    m_List = items;
    m_Max = max;

    if (max == 0)
        ui->lblTitle->setText("Select any item:");
    else if (max > 1)
        ui->lblTitle->setText(QString("Select %1 items:").arg(max));
    else
        ui->lblTitle->setText(QString("Select %1 item:").arg(max));

    ui->statusLayout->setAlignment(ui->chkQuiver, Qt::AlignRight);
    connect(ui->pbnDone, SIGNAL(clicked()), this, SLOT(DoneSlot()));
    connect(ui->pbnDropWeapon1, SIGNAL(clicked()), this, SLOT(DropWeapon1Slot()));
    connect(ui->pbnDropWeapon2, SIGNAL(clicked()), this, SLOT(DropWeapon2Slot()));

    //if (max > 0)
    //    ui->pbnDone->setEnabled(false);

    m_RandomPicker = new RandomNumberPicker(this, ui->lblDice);
    connect(m_RandomPicker, SIGNAL(Random(int)), SLOT(RandomSlot(int)));

    ShowData(true);
}

PickItemsWindow::~PickItemsWindow()
{
    delete ui;
}

void PickItemsWindow::ShowData(bool full)
{
    int row = 0;
    QLayoutItem* child;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

#ifdef Q_WS_MAEMO_5
    ui->pbnDropWeapon1->setMaximumSize(120, 50);
    ui->pbnDropWeapon2->setMaximumSize(120, 50);
#endif
    if (full){
        while ((child = ui->layPickItems->takeAt(0)) != 0) {
            delete child->widget();
            delete child;
        }

        if (m_GoldCrowns){
            m_GoldCrownsLabel = new QLabel(this);
            if (m_GoldCrowns > 0)
                m_GoldCrownsLabel->setText(QString("%1 Gold Crowns").arg(m_GoldCrowns));
            else
                m_GoldCrownsLabel->setText("Gold Crowns");
            m_GoldCrownsLabel->setWordWrap(true);
            ui->layPickItems->addWidget(m_GoldCrownsLabel, row, 0);

            QLabel* lbl = new QLabel(this);
            ui->layPickItems->addWidget(lbl, row, 1);

            if (m_GoldCrowns > 0){
                QCheckBox* chk = new QCheckBox(this);
                chk->setObjectName("GC");
                chk->setSizePolicy(stretchZero);
                connect(chk, SIGNAL(clicked(bool)), this, SLOT(CheckItemSlot(bool)));
                ui->layPickItems->addWidget(chk, row, 2, Qt::AlignRight);
                m_Checkboxes.append(chk);
            }else{
                m_GoldCrownsButton = new QPushButton(this);
                m_GoldCrownsButton->setText("Pick");
                m_GoldCrownsButton->setMaximumSize(75, 50);
                connect(m_GoldCrownsButton, SIGNAL(clicked()), this, SLOT(PickGoldCrownsSlot()));
                ui->layPickItems->addWidget(m_GoldCrownsButton, row, 2);
            }
            row++;
        }

        int index = 0;
        foreach(Item* i, *m_List){
            QLabel* lbl = new QLabel(this);
            if (i->GetQuantity() > 1)
                lbl->setText(QString("%1 (%2)").arg(i->Name).arg(i->GetQuantity()));
            else
                lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->layPickItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->GetDescription());
            lbl->setWordWrap(true);
            ui->layPickItems->addWidget(lbl, row, 1);

            QCheckBox* chk = new QCheckBox(this);
            chk->setObjectName(QString::number(index++));
            chk->setSizePolicy(stretchZero);
            connect(chk, SIGNAL(clicked(bool)), this, SLOT(CheckItemSlot(bool)));
            ui->layPickItems->addWidget(chk, row, 2, Qt::AlignRight);
            m_Checkboxes.append(chk);
            row++;
        }
    }

    switch (m_Serie){
    case Book::Kai:
        ui->lblQuiver->setVisible(false);
        ui->chkQuiver->setVisible(false);
        ui->lblArrowsD->setVisible(false);
        ui->lblArrows->setVisible(false);
        break;
    default:
        break;
    }
    ui->lblCrowns->setText(QString::number(m_Player->GetGoldCrowns()));
    ui->lblArrows->setText(QString("%1/%2")
                           .arg(m_Player->GetArrows())
                           .arg(m_Player->GetMaxArrows()));
    ui->chkQuiver->setChecked(m_Player->HasQuiver());
    ui->pbnDropWeapon1->setEnabled(false);
    ui->pbnDropWeapon2->setEnabled(false);
    QList<Weapon*> weapons = m_Player->Weapons();
    if (weapons.count() > 0){
        ui->lblWeapon1->setText(weapons.at(0)->Name);
        ui->pbnDropWeapon1->setEnabled(true);
    }else{
        ui->lblWeapon1->setText("-");
    }

    if (weapons.count() > 1){
        ui->lblWeapon2->setText(weapons.at(1)->Name);
        ui->pbnDropWeapon2->setEnabled(true);
    }else{
        ui->lblWeapon2->setText("-");
    }

    while ((child = ui->layItems->takeAt(0)) != 0) {
        delete child->widget();
        delete child;
    }

    row = 0;
    int index = 0;
    if (!m_Player->HasBackpack()){
        QLabel* lbl = new QLabel(this);
        lbl->setText("You don't have the backpack!");
        ui->layItems->addWidget(lbl, 0, 0);
    }else{
        foreach(Item* i, m_Player->Items){
            if (i->GetIsBackpackItem()){
                QLabel* lbl = new QLabel(this);
                lbl->setSizePolicy(stretchZero);
                lbl->setText(QString("<b>%1:</b>").arg(row + 1));
                ui->layItems->addWidget(lbl, row, 0);

                lbl = new QLabel(this);
                lbl->setText(i->Name);
                lbl->setWordWrap(true);
                ui->layItems->addWidget(lbl, row, 1);

                lbl = new QLabel(this);
                lbl->setText(i->Description);
                lbl->setWordWrap(true);
                ui->layItems->addWidget(lbl, row, 2);

                QPushButton* pbn = new QPushButton(this);
                pbn->setObjectName(QString::number(index));
                pbn->setText("Discard");
#ifdef Q_WS_MAEMO_5
                pbn->setMaximumSize(120, 50);
#else
                pbn->setMaximumSize(75, 50);
#endif
                connect(pbn, SIGNAL(clicked()), this, SLOT(DropItemSlot()));
                ui->layItems->addWidget(pbn, row, 3);

                row++;
                for (int j=1; j<i->GetSize(); j++){
                    QLabel* lbl = new QLabel(this);
                    lbl->setSizePolicy(stretchZero);
                    lbl->setText(QString("<b>%1:</b>").arg(row + 1));
                    ui->layItems->addWidget(lbl, row, 0);

                    lbl = new QLabel(this);
                    lbl->setText("-");
                    lbl->setWordWrap(true);
                    ui->layItems->addWidget(lbl, row, 1);

                    row++;
                }
            }
            index++;
        }
    }
}

void PickItemsWindow::CheckItemSlot(bool value)
{
    if (sender()->objectName() == "GC"){
        if (value)
            m_SelectedGoldCrowns = m_GoldCrowns;
        else
            m_SelectedGoldCrowns = 0;
    }else{
        int idx = ((QWidget*)sender())->objectName().toInt();
        Item* i = m_List->at(idx);

        QCheckBox* chk = (QCheckBox*)sender();
        if (value){
            Weapon* w = qobject_cast<Weapon*>(i);
            if (w){
                if (m_Player->Weapons().count() + CountSelectedWeapons() >= 2){
                    QMessageBox msgBox(this);
                    msgBox.setText("You cannot carry more than two weapons.");
                    msgBox.exec();
                    chk->setChecked(false);
                    return;
                }
            }else{
                if (i->GetIsBackpack() && m_Player->HasBackpack()){
                    QMessageBox msgBox(this);
                    msgBox.setText("You have the backpack and cannot carry another one.");
                    msgBox.exec();
                    chk->setChecked(false);
                    return;
                }else if (!i->GetIsSpecial()){
                    if (i->GetIsArrow()){
                        if (!m_Player->HasQuiver()){
                            QMessageBox msgBox(this);
                            msgBox.setText("You don't have a quiver and cannot carry arrows.");
                            msgBox.exec();
                            chk->setChecked(false);
                            return;
                        }
                    }else if (!HasBackpack()){
                        QMessageBox msgBox(this);
                        msgBox.setText("You don't have the backpack and cannot carry any item.");
                        msgBox.exec();
                        chk->setChecked(false);
                        return;
                    }else if (m_Player->GetBackpackFreeSpace() - SelectedItemsSize() - i->GetTotalSize() < 0){
                        QMessageBox msgBox(this);
                        msgBox.setText("You cannot carry more items.");
                        msgBox.exec();
                        chk->setChecked(false);
                        return;
                    }
                }
            }
            m_Selected.append(i);
        }else
            m_Selected.removeOne(i);
    }

    int count = m_Selected.count();
    if (m_SelectedGoldCrowns)
        count++;

    if (m_Max > 0){
        if (count == m_Max){
            //ui->pbnDone->setEnabled(true);
            foreach(QCheckBox* c, m_Checkboxes)
                c->setEnabled(c->isChecked());
        }else{
            //ui->pbnDone->setEnabled(false);
            foreach(QCheckBox* c, m_Checkboxes)
                c->setEnabled(true);
        }
    }
}

void PickItemsWindow::DoneSlot()
{
    m_Player->SetGoldCrowns(m_Player->GetGoldCrowns() + m_SelectedGoldCrowns);
    foreach (Item*i, m_Selected){
        Weapon* w = qobject_cast<Weapon*>(i);
        if (w)
            m_Player->Items.append(w);
        else{
            if (i->GetIsArrow()){
                m_Player->SetArrows(m_Player->GetArrows() + i->GetQuantity());
            }else if (i->GetIsBackpack()){
                m_Player->SetHasBackpack(true);
            }else{
                int qty = i->GetQuantity();
                for (int idx=0; idx<qty; idx++){
                    if (i->GetIsSpecial() || m_Player->GetBackpackFreeSpace() >= i->GetSize()){
                        i->SetQuantity(1);
                        m_Player->Items.append(i);
                    }
                }
            }
        }
    }
    accept();
}

void PickItemsWindow::DropWeapon1Slot()
{
    Weapon* w = m_Player->Weapons().at(0);
    if (DropWeapon(w))
        ShowData(false);
}

void PickItemsWindow::DropWeapon2Slot()
{
    Weapon* w = m_Player->Weapons().at(1);
    if (DropWeapon(w))
        ShowData(false);
}

bool PickItemsWindow::DropWeapon(Weapon* weapon)
{
    if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Discard the %1?").arg(weapon->Name)) == QMessageBox::Yes){
        weapon->Unequip();
        m_Player->CheckEndurance();
        m_Player->Items.removeOne(weapon);
        delete weapon;
        return true;
    }
    return false;
}

int PickItemsWindow::CountSelectedWeapons()
{
    int res = 0;
    foreach (Item*i, m_Selected){
        Weapon* w = qobject_cast<Weapon*>(i);
        if (w)
            res++;
    }

    return res;
}

int PickItemsWindow::SelectedItemsSize()
{
    int res = 0;
    foreach (Item*i, m_Selected){
        if (!i->GetIsSpecial())
            res += i->GetTotalSize();
    }

    return res;
}

void PickItemsWindow::DropItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Player->Items.at(idx);
    if (DropItem(i)){
        ShowData(false);
    }
}

bool PickItemsWindow::DropItem(Item* item)
{
    if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Discard the %1?").arg(item->Name)) == QMessageBox::Yes){
        item->Unequip();
        m_Player->CheckEndurance();
        m_Player->Items.removeOne(item);
        delete item;
        return true;
    }
    return false;
}

bool PickItemsWindow::HasBackpack()
{
    if (m_Player->HasBackpack())
        return true;

    foreach (Item* i, m_Selected)
        if (i->GetIsBackpack())
            return true;

    return false;
}

void PickItemsWindow::PickGoldCrownsSlot()
{
    QPushButton* pbn = (QPushButton*)sender();
    pbn->setEnabled(false);
    m_RandomPicker->GetRandomNumber(this);
}

void PickItemsWindow::RandomSlot(int random)
{
    m_GoldCrowns = random + (-m_GoldCrowns -1);
    m_GoldCrownsLabel->setText(QString("%1 Gold Crowns").arg(m_GoldCrowns));
    ui->layPickItems->removeWidget(m_GoldCrownsButton);
    delete m_GoldCrownsButton;
    m_GoldCrownsButton = NULL;

    QCheckBox* chk = new QCheckBox(this);
    chk->setObjectName("GC");
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);
    chk->setSizePolicy(stretchZero);
    connect(chk, SIGNAL(clicked(bool)), this, SLOT(CheckItemSlot(bool)));
    ui->layPickItems->addWidget(chk, 0, 2, Qt::AlignRight);
    m_Checkboxes.append(chk);
}
