#include "combatskillwindow.h"
#include "ui_combatskillwindow.h"

#include <QLabel>
CombatSkillWindow::CombatSkillWindow(QWidget *parent, Player* player, Enemy* enemy) :
    QDialog(parent),
    ui(new Ui::CombatSkillWindow)
{
    ui->setupUi(this);

    m_Player = player;
    m_Enemy = enemy;
    ShowData();
}

void CombatSkillWindow::ShowData()
{
    QStringList desc = m_Player->GetCombatSkillDescription(m_Enemy);

    int row = 0;
    foreach (QString line, desc){
        QStringList elements = line.split("|");
        QLabel* lbl = new QLabel(this);
        lbl->setText(elements.at(0));
        lbl->setWordWrap(true);
        ui->layCombatSkill->addWidget(lbl, row, 0);

        lbl = new QLabel(this);
        lbl->setText(elements.at(1));
        lbl->setWordWrap(false);
        lbl->setAlignment(Qt::AlignVCenter | Qt::AlignRight);
        ui->layCombatSkill->addWidget(lbl, row, 1);

        row++;
    }

    ui->lblTotal->setText(QString::number(m_Player->GetCombatSkill(m_Enemy)));
}

CombatSkillWindow::~CombatSkillWindow()
{
    delete ui;
}
