#include "aonlicensewindow.h"
#include "ui_aonlicensewindow.h"
#include <QFile>

AonLicenseWindow::AonLicenseWindow(QWidget *parent) :
    DialogWindow(parent),
    ui(new Ui::AonLicenseWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    ui->pbnOk->setEnabled(false);
    connect(ui->chkAccept, SIGNAL(toggled(bool)), this, SLOT(AcceptSlot(bool)));
    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(OkSlot()));

    QFile* file = new QFile(":/AON_license.html");
    if (file->open(QIODevice::ReadOnly | QIODevice::Text)){
        QByteArray data = file->readAll();
        QString license = QString::fromUtf8(data);
        ui->webView->setHtml(license);
        file->close();
    }
    delete file;
}

AonLicenseWindow::~AonLicenseWindow()
{
    delete ui;
}

void AonLicenseWindow::AcceptSlot(bool value)
{
    ui->pbnOk->setEnabled(value);
}

void AonLicenseWindow::OkSlot()
{
    accept();
}
