#ifndef STATUSWINDOW_H
#define STATUSWINDOW_H

#include <QMainWindow>
#include <QEventLoop>
#include <QMessageBox>
#include <QScriptEngine>
#include "controls/dialogwindow.h"
#include "core/player.h"

namespace Ui {
    class StatusWindow;
}

class StatusWindow : public DialogWindow
{
    Q_OBJECT

public:
    explicit StatusWindow(QWidget *parent = 0, Player* player=0, Section* section=0, QScriptEngine* engine=0, QScriptValue* functions=0);
    ~StatusWindow();

    QList<Item*> UsedItems() { return m_UsedItems; }

private:
    Ui::StatusWindow *ui;

    int m_Serie;
    QScriptEngine* m_Engine;
    QScriptValue* m_Functions;
    QList<Item*> m_UsedItems;
    Book* m_Book;
    Section* m_Section;
    Player* m_Player;

    void ShowData();
    bool EquipWeapon(Weapon* weapon);
    bool EquipArmor(Armor* armor);
    bool DropWeapon(Weapon* weapon);
    bool DropItem(Item* item);
    void ClearLayout(QLayout* layout);

private slots:
    void EquipWeapon1Slot();
    void EquipWeapon2Slot();
    void DropWeapon1Slot();
    void DropWeapon2Slot();
    void DropItemSlot();
    void EquipItemSlot();
    void TakeItemSlot();
    void UseItemSlot();
    void TakeGoldCrownsSlot();
    void DiscipleLinkSlot(QString link);
    void CombatSkillLinkSlot(QString link);
    void EditNotesSlot();
    void EditNotesClosedSlot();
};

#endif // STATUSWINDOW_H

