#include "fontswindow.h"
#include "ui_fontswindow.h"
#include <QFontDatabase>

FontsWindow::FontsWindow(QWidget *parent, QFont font) :
    QDialog(parent),
    ui(new Ui::FontsWindow)
{
    ui->setupUi(this);

    QFontDatabase fDb;
    int index = 0;
    foreach (const QString family, fDb.families()){
        ui->cmbFont->addItem(family);
        if (family == font.family())
            ui->cmbFont->setCurrentIndex(index);
        index++;
    }

    index = 0;
    for (int i=4; i<50; i++){
        ui->cmbSize->addItem(QString::number(i));
        if (font.pixelSize() == i)
            ui->cmbSize->setCurrentIndex(index);
        index++;
    }

    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(accept()));
    connect(ui->cmbFont, SIGNAL(currentIndexChanged(int)), this, SLOT(FontChangedSlot(int)));
    connect(ui->cmbSize, SIGNAL(currentIndexChanged(int)), this, SLOT(FontChangedSlot(int)));

    ui->txtSample->setPlainText("Sample");
    FontChangedSlot(0);
}

FontsWindow::~FontsWindow()
{
    delete ui;
}

QFont FontsWindow::GetSelected()
{
    QFont f(ui->cmbFont->currentText(), -1, false);
    f.setPixelSize(ui->cmbSize->currentText().toInt());
    return f;
}

void FontsWindow::FontChangedSlot(int)
{
    QFont f(ui->cmbFont->currentText(), -1, false);
    f.setPixelSize(ui->cmbSize->currentText().toInt());
    ui->txtSample->setFont(f);
}
