#ifndef PLAYERCREATIONWINDOW_H
#define PLAYERCREATIONWINDOW_H

#include <QMainWindow>
#include <QEventLoop>
#include "controls/dialogwindow.h"
#include "core/player.h"
#include "randomnumberpicker.h"

namespace Ui {
    class PlayerCreationWindow;
}

class PlayerCreationWindow : public DialogWindow
{
    Q_OBJECT

public:
    explicit PlayerCreationWindow(QWidget *parent = 0);
    ~PlayerCreationWindow();

    Player* GetPlayer();

private:
    enum Random{
        RandomSkill,
        RandomEndurance,
        RandomCrowns,
        RandomItem,
        RandomWeaponSkill
    };

    Ui::PlayerCreationWindow *ui;

    Book* m_Book;
    int m_RandomWeaponskill;
    int m_Random;
    RandomNumberPicker* m_RandomPicker;
    Player* m_Player;
    void PickRandomNumber();

    void EnableButtons(bool enable);
    void ShowData();

    bool m_SkillDone;
    bool m_EnduranceDone;
    bool m_CrownsDone;
    bool m_WeaponskillDone;
    bool m_ItemDone;

    bool CheckDisciplines();
    void CheckDone();

private slots:
    void RandomSlot(int);

    void CombatSkillSlot();
    void EnduranceSlot();
    void CrownsSlot();
    void ItemSlot();
    void WeaponskillRandomSlot();

    void AnimalKinshipSlot(bool);
    void CamouflageSlot(bool);
    void HealingSlot(bool);
    void HuntingSlot(bool);
    void MindblastSlot(bool);
    void MindOverMatterSlot(bool);
    void MindshieldSlot(bool);
    void SixthSenseSlot(bool);
    void TrackingSlot(bool);
    void WeaponskillSlot(bool);

    void RulesSlot();
    void DiscipleLinkSlot(QString link);
};

#endif // PLAYERCREATIONWINDOW_H
