#include "dialogwindow.h"
#include <QDialog>
#include <QCloseEvent>

DialogWindow::DialogWindow(QWidget *parent) :
    QMainWindow(parent)
{
    m_Loop = NULL;
    m_CanClose = false;
    m_Result = QDialog::Rejected;
}

DialogWindow::~DialogWindow()
{
    if (m_Loop)
        delete m_Loop;
}

int DialogWindow::exec()
{
    setWindowModality(Qt::WindowModal);
    m_Loop = new QEventLoop(this);
    show();
    m_Loop->exec();
    return m_Result;
}

void DialogWindow::reject()
{
    m_Result = QDialog::Rejected;
    m_CanClose = true;
    close();
}

void DialogWindow::accept()
{
    m_Result = QDialog::Accepted;
    m_CanClose = true;
    close();
}

void DialogWindow::closeEvent(QCloseEvent* event)
{
    if (m_CanClose){
        if (m_Loop)
            m_Loop->quit();
        event->accept();
    }else{
        event->ignore();
    }
}
