#ifndef KAIDISCIPLINE_H
#define KAIDISCIPLINE_H

#include <QObject>
#include <QStringList>
#include "item.h"

class Player;

class LoreCircle : public QObject
{
    Q_OBJECT
public:
    enum Circles
    {
       None = -1,
       CircleOfFire,
       CircleOfLight,
       CircleOfSolaris,
       CircleOfSpirit
    };

    explicit LoreCircle(QObject *parent = 0, Circles Circle=None);

    QString Name();
    int EnduranceBonus;
    int CombatSkillBonus;
    QStringList Disciplines;

    bool Check(Player* player);

private:
    Circles m_Circle;
};

class LoreCircles : public QObject
{
    Q_OBJECT

public:
    explicit LoreCircles(QObject *parent = 0);

    static QList<LoreCircle*> Circles;
    static void InitCircles();
    static void ClearCircles();
};


class KaiDiscipline : public QObject
{
    Q_OBJECT
public:
    explicit KaiDiscipline(QObject *parent = 0);
    KaiDiscipline(const KaiDiscipline& discipline);

    int Serie;
    QList<int> Circles;
    bool Active;
    QString Name;
    QString HelpText;
    int CombatSkillDelta;

    virtual QString Description();

    virtual QString ToString();
    virtual void FromString(QString string);
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Kai:
class Camouflage : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Camouflage(QObject *parent = 0);
};

class Hunting : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Hunting(QObject *parent = 0);
};

class SixthSense : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit SixthSense(QObject *parent = 0);
};

class Tracking : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Tracking(QObject *parent = 0);
};

class Healing : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Healing(QObject *parent = 0);
};

class Weaponskill : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Weaponskill(QObject *parent = 0);
    Weaponskill(const Weaponskill& discipline);

    int Weapon;

    void FromString(QString string);
    QString ToString();
    QString Description();
};

class Mindshield : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Mindshield(QObject *parent = 0);
};

class Mindblast : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Mindblast(QObject *parent = 0);
};

class AnimalKinship : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit AnimalKinship(QObject *parent = 0);
};

class MindOverMatter : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit MindOverMatter(QObject *parent = 0);
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Magnakai:
class Weaponmastery : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Weaponmastery(QObject *parent = 0);

    QList<int> Weapons;
    void FromString(QString string);
    QString ToString();
};

class AnimalControl : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit AnimalControl(QObject *parent = 0);
};


class Curing : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Curing(QObject *parent = 0);
};

class Invisibility : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Invisibility(QObject *parent = 0);
};

class Huntmastery : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Huntmastery(QObject *parent = 0);
};

class Pathsmanship : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Pathsmanship(QObject *parent = 0);
};

class PsiSurge : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit PsiSurge(QObject *parent = 0);
};

class PsiScreen : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit PsiScreen(QObject *parent = 0);
};

class Nexus : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Nexus(QObject *parent = 0);
};

class Divination : public KaiDiscipline
{
    Q_OBJECT
public:
    explicit Divination(QObject *parent = 0);
};

#endif // KAIDISCIPLINE_H
