#ifndef SHOPWINDOW_H
#define SHOPWINDOW_H

#include <QMainWindow>
#include <QEventLoop>
#include <QMessageBox>
#include "core/player.h"

namespace Ui {
    class ShopWindow;
}

class ShopWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit ShopWindow(QWidget *parent = 0, Player* player=0, Section* section=0);
    ~ShopWindow();

    void exec();

protected:
    void closeEvent(QCloseEvent* event);

private:
    Ui::ShopWindow *ui;

    QEventLoop* m_Loop;
    Player* m_Player;
    Section* m_Section;

    void ShowData();
    bool SellItem(Item* item, int price);
    bool DropItem(Item* item);
    bool SellWeapon(Weapon* weapon, int price);
    bool DropWeapon(Weapon* weapon);
    int GetSellPrice(Item* i);

private slots:
    void BuyItemSlot();
    void SellItemSlot();
    void DropItemSlot();
    void SellWeapon1Slot();
    void SellWeapon2Slot();
    void DropWeapon1Slot();
    void DropWeapon2Slot();
};

#endif // SHOPWINDOW_H
