#include "selectgoldencrownswindow.h"
#include "ui_selectgoldencrownswindow.h"

SelectGoldenCrownsWindow::SelectGoldenCrownsWindow(QWidget *parent, Player* player, int min) :
    QDialog(parent),
    ui(new Ui::SelectGoldenCrownsWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    m_Player = player;
    m_MinValue = min;
    m_Value = m_MinValue;
    ui->lblValue->setText(QString::number(m_Value));

    connect(ui->pbnMinus, SIGNAL(clicked()), this, SLOT(MinusSlot()));
    connect(ui->pbnPlus, SIGNAL(clicked()), this, SLOT(PlusSlot()));
    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(OkSlot()));
}

SelectGoldenCrownsWindow::~SelectGoldenCrownsWindow()
{
    delete ui;
}

void SelectGoldenCrownsWindow::MinusSlot()
{
    if (m_Value > m_MinValue){
        m_Value--;
        ui->lblValue->setText(QString::number(m_Value));
    }
}

void SelectGoldenCrownsWindow::PlusSlot()
{
    if (m_Value < m_Player->GoldCrowns){
        m_Value++;
        ui->lblValue->setText(QString::number(m_Value));
    }
}

void SelectGoldenCrownsWindow::OkSlot()
{
    accept();
}

int SelectGoldenCrownsWindow::GetSelectedValue()
{
    return m_Value;
}
